/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Arrays;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.xtext.ui.editor.contentassist.CompletionProposalComputer;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ContextInformationComputer;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalComparator;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalPostProcessor;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.IContextInformationAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContextInformationProvider;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateProposalProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class XtextContentAssistProcessor
implements IContentAssistProcessor,
CompletionProposalComputer.State,
ContextInformationComputer.State {
    public static final String COMPLETION_AUTO_ACTIVATION_CHARS = "org.eclipse.xtext.ui.editor.XtextContentAssistProcessor.COMPLETION_AUTO_ACTIVATION_CHARS";
    public static final String CONTEXT_INFO_AUTO_ACTIVATION_CHARS = "org.eclipse.xtext.ui.editor.XtextContentAssistProcessor.CONTEXT_INFO_AUTO_ACTIVATION_CHARS";
    public static final String ERROR_MESSAGE = "org.eclipse.xtext.ui.editor.XtextContentAssistProcessor.ERROR_MESSAGE";
    @Inject
    private ContentAssistContext.Factory contextFactory;
    @Inject(optional=true)
    private ITemplateProposalProvider templateProposalProvider;
    @Inject(optional=true)
    private IContentProposalProvider contentProposalProvider;
    @Inject(optional=true)
    private IContextInformationProvider contextInformationProvider;
    @Inject
    private ICompletionProposalComparator completionProposalComparator;
    @Inject
    private ICompletionProposalPostProcessor completionProposalPostProcessor;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.XtextContentAssistProcessor.COMPLETION_AUTO_ACTIVATION_CHARS")
    private String completionProposalAutoActivationCharacters = null;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.XtextContentAssistProcessor.CONTEXT_INFO_AUTO_ACTIVATION_CHARS")
    private String contextInformationAutoActivationCharacters = null;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.XtextContentAssistProcessor.ERROR_MESSAGE")
    private String errorMessage = null;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (this.contentProposalProvider == null) {
            return null;
        }
        IXtextDocument document = (IXtextDocument)viewer.getDocument();
        ICompletionProposal[] result = (ICompletionProposal[])document.readOnly(this.createCompletionProposalComputer(viewer, offset));
        Arrays.sort(result, this.completionProposalComparator);
        result = this.completionProposalPostProcessor.postProcess(result);
        return result;
    }

    protected CompletionProposalComputer createCompletionProposalComputer(ITextViewer viewer, int offset) {
        return new CompletionProposalComputer(this, viewer, offset);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        if (this.contextInformationProvider == null) {
            return null;
        }
        IXtextDocument document = (IXtextDocument)viewer.getDocument();
        return (IContextInformation[])document.readOnly(this.createContextInformationComputer(viewer, offset));
    }

    protected ContextInformationComputer createContextInformationComputer(ITextViewer viewer, int offset) {
        return new ContextInformationComputer(this, viewer, offset);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        if (this.completionProposalAutoActivationCharacters != null) {
            return this.completionProposalAutoActivationCharacters.toCharArray();
        }
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        if (this.contextInformationAutoActivationCharacters != null) {
            return this.contextInformationAutoActivationCharacters.toCharArray();
        }
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setCompletionProposalAutoActivationCharacters(String completionProposalAutoActivationCharacters) {
        this.completionProposalAutoActivationCharacters = completionProposalAutoActivationCharacters;
    }

    public void setContextFactory(ContentAssistContext.Factory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public ContentAssistContext.Factory getContextFactory() {
        return this.contextFactory;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setContextInformationAutoActivationCharacters(String contextInformationAutoActivationCharacters) {
        this.contextInformationAutoActivationCharacters = contextInformationAutoActivationCharacters;
    }

    public void setContentProposalProvider(IContentProposalProvider contentProposalProvider) {
        this.contentProposalProvider = contentProposalProvider;
    }

    public IContentProposalProvider getContentProposalProvider() {
        return this.contentProposalProvider;
    }

    public void setTemplateProposalProvider(ITemplateProposalProvider templateProposalProvider) {
        this.templateProposalProvider = templateProposalProvider;
    }

    public ITemplateProposalProvider getTemplateProposalProvider() {
        return this.templateProposalProvider;
    }

    public IContextInformationProvider getContextInformationProvider() {
        return this.contextInformationProvider;
    }

    public ICompletionProposalAcceptor decorateAcceptor(ICompletionProposalAcceptor acceptor) {
        return acceptor;
    }

    public ITemplateAcceptor decorateAcceptor(ITemplateAcceptor acceptor) {
        return acceptor;
    }

    public IContextInformationAcceptor decorateAcceptor(IContextInformationAcceptor acceptor) {
        return acceptor;
    }

    public void setCompletionProposalPostProcessor(ICompletionProposalPostProcessor completionProposalPostProcessor) {
        this.completionProposalPostProcessor = completionProposalPostProcessor;
    }

    public ICompletionProposalPostProcessor getCompletionProposalPostProcessor() {
        return this.completionProposalPostProcessor;
    }
}

