/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;

public class JavaIoFileSystemAccess
extends AbstractFileSystemAccess {
    public void generateFile(String fileName, String outputConfigName, CharSequence contents) {
        File file = this.getFile(fileName, outputConfigName);
        try {
            this.createFolder(file.getParentFile());
            FileWriter writer = new FileWriter(file);
            writer.append(contents);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected File getFile(String fileName, String outputConfigName) {
        String outlet = this.getPathes().get(outputConfigName);
        if (outlet == null) {
            throw new IllegalArgumentException("A slot with name '" + outputConfigName + "' has not been configured.");
        }
        String pathName = this.toSystemFileName(String.valueOf(outlet) + "/" + fileName);
        File file = new File(pathName);
        return file;
    }

    protected void createFolder(File parent) {
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public void deleteFile(String fileName, String outputConfiguration) {
        File file = this.getFile(fileName, outputConfiguration);
        if (file.exists()) {
            file.delete();
        }
    }

    protected String toSystemFileName(String fileName) {
        return fileName.replace("/", File.separator);
    }
}

