/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.ClassFinder;
import org.eclipse.xtext.common.types.access.impl.ClassMirror;
import org.eclipse.xtext.common.types.access.impl.ClassURIHelper;
import org.eclipse.xtext.common.types.access.impl.DeclaredTypeFactory;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathTypeProvider
extends AbstractJvmTypeProvider {
    private final ClassFinder classFinder;
    private final DeclaredTypeFactory declaredTypeFactory;
    private final ClassURIHelper uriHelper;

    public ClasspathTypeProvider(ClassLoader classLoader, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        super(resourceSet, indexedJvmTypeAccess);
        this.classFinder = this.createClassFinder(classLoader);
        this.uriHelper = this.createClassURIHelper();
        this.declaredTypeFactory = this.createDeclaredTypeFactory();
    }

    @Deprecated
    public ClasspathTypeProvider(ClassLoader classLoader, ResourceSet resourceSet) {
        this(classLoader, resourceSet, null);
    }

    protected ClassFinder createClassFinder(ClassLoader classLoader) {
        return new ClassFinder(classLoader);
    }

    protected DeclaredTypeFactory createDeclaredTypeFactory() {
        return new DeclaredTypeFactory(this.uriHelper);
    }

    protected ClassURIHelper createClassURIHelper() {
        return new ClassURIHelper();
    }

    public ClassURIHelper getClassURIHelper() {
        return this.uriHelper;
    }

    public DeclaredTypeFactory getDeclaredTypeFactory() {
        return this.declaredTypeFactory;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    @Override
    public JvmType findTypeByName(String name) {
        try {
            URI proxyURI;
            EObject candidate;
            Class<?> clazz = this.classFinder.forName(name);
            URI resourceURI = this.uriHelper.createResourceURI(clazz);
            IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
            if (indexedJvmTypeAccess != null && (candidate = indexedJvmTypeAccess.getIndexedJvmType(proxyURI = resourceURI.appendFragment(this.uriHelper.getFragment(clazz)), this.getResourceSet())) instanceof JvmType) {
                return (JvmType)candidate;
            }
            TypeResource result = (TypeResource)this.getResourceSet().getResource(resourceURI, true);
            return this.findTypeByClass(clazz, (Resource)result);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    protected IMirror createMirrorForFQN(String name) {
        try {
            Class<?> clazz = this.classFinder.forName(name);
            return this.createMirror(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ClassMirror createMirror(Class<?> clazz) {
        return ClassMirror.createClassMirror(clazz, this.declaredTypeFactory);
    }

    public JvmType findTypeByClass(Class<?> clazz, Resource resource) {
        String fragment = this.uriHelper.getFragment(clazz);
        JvmType result = (JvmType)resource.getEObject(fragment);
        if (result == null) {
            throw new IllegalStateException("Resource has not been loaded");
        }
        return result;
    }
}

