/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.util.ITextRegion;

public class XtextHyperlinkHelper
extends HyperlinkHelper {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        ITextRegion nameLocation;
        super.createHyperlinksByOffset(resource, offset, acceptor);
        EObject objectAtOffset = this.eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (objectAtOffset instanceof AbstractRule && (nameLocation = this.locationInFileProvider.getSignificantTextRegion(objectAtOffset, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_RULE__NAME, 0)) != null && nameLocation.contains(offset)) {
            AbstractRule rule = (AbstractRule)objectAtOffset;
            this.createLinksToBase(nameLocation, rule, acceptor);
            if (rule.getType() != null && rule.getType().getClassifier() != null && NodeModelUtils.getNode((EObject)rule.getType()) == null) {
                this.createHyperlinksTo(resource, this.toRegion(nameLocation), (EObject)rule.getType().getClassifier(), acceptor);
            }
        }
    }

    protected void createLinksToBase(ITextRegion nameLocation, AbstractRule rule, IHyperlinkAcceptor acceptor) {
        HashSet visited = Sets.newHashSet();
        Grammar grammar = GrammarUtil.getGrammar((EObject)rule);
        for (Grammar used : grammar.getUsedGrammars()) {
            String ruleName;
            AbstractRule overwritten = GrammarUtil.findRuleForName((Grammar)used, (String)(ruleName = rule.getName()));
            if (overwritten == null || !visited.add(overwritten)) continue;
            URIConverter uriConverter = rule.eResource().getResourceSet().getURIConverter();
            String hyperlinkText = String.valueOf(this.getLabelProvider().getText((Object)rule)) + " - " + GrammarUtil.getGrammar((EObject)overwritten).getName();
            URI uri = uriConverter.normalize(EcoreUtil.getURI((EObject)overwritten));
            XtextHyperlink result = (XtextHyperlink)this.getHyperlinkProvider().get();
            this.deprecatedSetRegion(result, this.toRegion(nameLocation));
            result.setURI(uri);
            result.setHyperlinkText(hyperlinkText);
            result.setTypeLabel("Go To Base");
            acceptor.accept((IHyperlink)result);
        }
    }

    @Deprecated
    private void deprecatedSetRegion(XtextHyperlink link, Region region) {
        link.setHyperlinkRegion(region);
    }

    protected Region toRegion(ITextRegion location) {
        return new Region(location.getOffset(), location.getLength());
    }

    public void createHyperlinksTo(XtextResource from, Region region, EObject to, IHyperlinkAcceptor acceptor) {
        if (this.acceptHyperLink(from, to)) {
            super.createHyperlinksTo(from, region, to, acceptor);
        }
    }

    protected boolean acceptHyperLink(XtextResource resource, EObject objectAtOffset) {
        if (objectAtOffset instanceof EClass) {
            EClass eClass = (EClass)objectAtOffset;
            Grammar grammar = GrammarUtil.getGrammar((EObject)resource.getEObject("/"));
            List allMetamodelDeclarations = GrammarUtil.allMetamodelDeclarations((Grammar)grammar);
            for (GeneratedMetamodel generatedMetamodel : Iterables.filter((Iterable)allMetamodelDeclarations, GeneratedMetamodel.class)) {
                if (!eClass.getEPackage().equals(generatedMetamodel.getEPackage())) continue;
                return false;
            }
        }
        return true;
    }
}

