/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.templates;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;

public class XtextTemplateContext
extends DocumentTemplateContext {
    private final ContentAssistContext contentAssistContext;
    private final IScopeProvider scopeProvider;

    public XtextTemplateContext(TemplateContextType type, IDocument document, Position position, ContentAssistContext contentAssistContext, IScopeProvider scopeProvider) {
        super(type, document, position);
        this.contentAssistContext = contentAssistContext;
        this.scopeProvider = scopeProvider;
    }

    public ContentAssistContext getContentAssistContext() {
        return this.contentAssistContext;
    }

    public IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = this.createTemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    public TemplateBuffer evaluateForDisplay(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    protected TemplateTranslator createTemplateTranslator() {
        try {
            int offset = this.getStart();
            IRegion lineRegion = this.getDocument().getLineInformationOfOffset(offset);
            String line = this.getDocument().get(lineRegion.getOffset(), lineRegion.getLength());
            String lineDelimiter = this.getDocument() instanceof IDocumentExtension4 ? ((IDocumentExtension4)this.getDocument()).getDefaultLineDelimiter() : null;
            int i = 0;
            while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            if (i != 0) {
                return new IndentationAwareTemplateTranslator(line.substring(0, i), lineDelimiter);
            }
            return new IndentationAwareTemplateTranslator("", lineDelimiter);
        }
        catch (BadLocationException ex) {
            return new TemplateTranslator();
        }
    }

    public static class IndentationAwareTemplateTranslator
    extends TemplateTranslator {
        private final String indentation;
        private final String lineDelimiter;

        public IndentationAwareTemplateTranslator(String indentation, String lineDelimiter) {
            this.indentation = indentation;
            this.lineDelimiter = lineDelimiter == null ? System.lineSeparator() : lineDelimiter;
        }

        public TemplateBuffer translate(Template template) throws TemplateException {
            return this.translate(template.getPattern());
        }

        public TemplateBuffer translate(String string) throws TemplateException {
            return super.translate(string.replaceAll("(\r\n?)|(\n)", String.valueOf(this.lineDelimiter) + this.indentation));
        }
    }
}

