/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.util.Arrays;

public enum JavaVersion {
    JAVA5("Java 5", new String[]{"1.5"}, "J2SE-1.5", "-1.5", 0x310000L),
    JAVA6("Java 6", new String[]{"1.6", "6"}, "JavaSE-1.6", "-1.6", 0x320000L),
    JAVA7("Java 7", new String[]{"1.7", "7"}, "JavaSE-1.7", "-1.7", 0x330000L),
    JAVA8("Java 8", new String[]{"1.8", "8"}, "JavaSE-1.8", "-1.8", 0x340000L),
    JAVA9("Java 9", new String[]{"9", "1.9"}, "JavaSE-9", "-1.9", 0x350000L),
    JAVA10("Java 10", new String[]{"10", "1.10"}, "JavaSE-10", "-1.10", 0x360000L),
    JAVA11("Java 11", new String[]{"11", "1.11"}, "JavaSE-11", "-1.11", 0x370000L),
    JAVA17("Java 17", new String[]{"17", "1.17"}, "JavaSE-17", "-1.17", 0x3D0000L);

    private final String label;
    private final String[] qualifiers;
    private final String bree;
    private final String complianceLevelArg;
    private final long jdtClassFileConstant;

    private JavaVersion(String label, String[] qualifiers, String bree, String complianceLevelArg, long jdtClassFileConstant) {
        this.label = label;
        this.qualifiers = qualifiers;
        this.bree = bree;
        this.complianceLevelArg = complianceLevelArg;
        this.jdtClassFileConstant = jdtClassFileConstant;
    }

    public static JavaVersion fromQualifier(String qualifier) {
        JavaVersion[] values = JavaVersion.values();
        int i = values.length - 1;
        while (i >= 0) {
            JavaVersion candidate = values[i];
            if (Arrays.contains(candidate.qualifiers, qualifier)) {
                return candidate;
            }
            --i;
        }
        return null;
    }

    public static JavaVersion fromBree(String bree) {
        JavaVersion[] javaVersionArray = JavaVersion.values();
        int n = javaVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaVersion version = javaVersionArray[n2];
            if (version.bree.equals(bree)) {
                return version;
            }
            ++n2;
        }
        return null;
    }

    public String getComplianceLevelArg() {
        return this.complianceLevelArg;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getAllQualifiers() {
        return Collections.unmodifiableList(java.util.Arrays.asList(this.qualifiers));
    }

    public String getQualifier() {
        return this.qualifiers[0];
    }

    public String getBree() {
        return this.bree;
    }

    public boolean isAtLeast(JavaVersion other) {
        return this.ordinal() >= other.ordinal();
    }

    public long toJdtClassFileConstant() {
        return this.jdtClassFileConstant;
    }

    private static final class Constants {
        private static final int MAJOR_VERSION_1_5 = 49;
        private static final int MINOR_VERSION_0 = 0;
        private static final long JAVA5 = 0x310000L;
        private static final long JAVA6 = 0x320000L;
        private static final long JAVA7 = 0x330000L;
        private static final long JAVA8 = 0x340000L;
        private static final long JAVA9 = 0x350000L;
        private static final long JAVA10 = 0x360000L;
        private static final long JAVA11 = 0x370000L;
        private static final long JAVA17 = 0x3D0000L;

        private Constants() {
        }
    }
}

