/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.junit.formatter;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.formatting.AbstractFormatter;
import org.eclipse.xtext.xbase.formatting.IBasicFormatter;
import org.eclipse.xtext.xbase.formatting.TextReplacement;
import org.eclipse.xtext.xbase.junit.formatter.AssertingFormatterData;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.junit.Assert;

@Deprecated(forRemoval=true)
public class FormatterTester {
    @Inject
    private ParseHelper<EObject> parseHelper;
    @Inject
    private IBasicFormatter formatter;

    public void assertFormatted(Procedures.Procedure1<? super AssertingFormatterData> init) {
        AssertingFormatterData data = new AssertingFormatterData();
        data.setConfig(new MapBasedPreferenceValues(new HashMap()));
        init.apply((Object)data);
        this.assertFormatted(data);
    }

    public void assertFormatted(AssertingFormatterData it) {
        try {
            ICompositeNode rootNode;
            String fullToBeParsed = String.valueOf(it.getPrefix()) + it.getToBeFormatted() + it.getPostfix();
            EObject parsed = this.parseHelper.parse((CharSequence)fullToBeParsed);
            if (!it.isAllowErrors()) {
                Assert.assertEquals((String)Joiner.on((String)"\n").join((Iterable)parsed.eResource().getErrors()), (long)0L, (long)parsed.eResource().getErrors().size());
            }
            String oldDocument = null;
            IParseResult parseResult = ((XtextResource)parsed.eResource()).getParseResult();
            if (parseResult != null && (rootNode = parseResult.getRootNode()) != null) {
                oldDocument = rootNode.getText();
            }
            if (this.formatter instanceof AbstractFormatter) {
                ((AbstractFormatter)this.formatter).setAllowIdentityEdits(true);
            }
            int start = it.getPrefix().length();
            int length = it.getToBeFormatted().length();
            LinkedHashSet<TextReplacement> edits = new LinkedHashSet<TextReplacement>();
            Iterables.addAll(edits, (Iterable)this.formatter.format((XtextResource)parsed.eResource(), start, length, it.getCfg()));
            if (this.formatter instanceof AbstractFormatter && ((AbstractFormatter)this.formatter).isConflictOccurred()) {
                throw new RuntimeException("There are conflicting text edits, see console for details.");
            }
            if (!it.isAllowErrors()) {
                Iterables.addAll(edits, this.createMissingEditReplacements((XtextResource)parsed.eResource(), edits, start, length));
            }
            String newDocument = this.applyEdits(oldDocument, edits);
            try {
                Assert.assertEquals((Object)(String.valueOf(it.getPrefix()) + it.getExpectation() + it.getPostfix()).toString(), (Object)newDocument.toString());
            }
            catch (AssertionError e) {
                System.out.println(this.applyDebugEdits(oldDocument, edits));
                System.out.println();
                throw e;
            }
            String parsed2Doc = this.applyEdits(fullToBeParsed, this.formatter.format((XtextResource)parsed.eResource(), 0, fullToBeParsed.length(), it.getCfg()));
            EObject parsed2 = this.parseHelper.parse((CharSequence)parsed2Doc);
            if (!it.isAllowErrors()) {
                Assert.assertEquals((long)0L, (long)parsed2.eResource().getErrors().size());
            }
            List edits2 = this.formatter.format((XtextResource)parsed2.eResource(), 0, parsed2Doc.length(), it.getCfg());
            String newDocument2 = this.applyEdits(parsed2Doc, edits2);
            try {
                Assert.assertEquals((Object)parsed2Doc, (Object)newDocument2.toString());
            }
            catch (AssertionError e) {
                System.out.println(this.applyDebugEdits(newDocument, edits2));
                System.out.println();
                throw e;
            }
        }
        catch (Throwable e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected String applyEdits(String oldDocument, Collection<TextReplacement> edits) {
        int lastOffset = 0;
        StringBuilder newDocument = new StringBuilder();
        for (TextReplacement edit : IterableExtensions.sortBy(edits, TextReplacement::getOffset)) {
            newDocument.append(oldDocument.substring(lastOffset, edit.getOffset()));
            newDocument.append(edit.getText());
            lastOffset = edit.getOffset() + edit.getLength();
        }
        newDocument.append(oldDocument.substring(lastOffset, oldDocument.length()));
        return newDocument.toString();
    }

    protected String applyDebugEdits(String oldDocument, Collection<TextReplacement> edits) {
        int lastOffset = 0;
        StringBuilder debugTrace = new StringBuilder();
        for (TextReplacement edit : IterableExtensions.sortBy(edits, TextReplacement::getOffset)) {
            debugTrace.append(oldDocument.substring(lastOffset, edit.getOffset()));
            debugTrace.append("[" + oldDocument.substring(edit.getOffset(), edit.getOffset() + edit.getLength()) + "|" + edit.getText() + "]");
            lastOffset = edit.getOffset() + edit.getLength();
        }
        debugTrace.append(oldDocument.substring(lastOffset, oldDocument.length()));
        return debugTrace.toString();
    }

    protected ArrayList<TextReplacement> createMissingEditReplacements(XtextResource res, Collection<TextReplacement> edits, int offset, int length) {
        ICompositeNode rootNode;
        Set offsets = IterableExtensions.toSet((Iterable)Iterables.transform(edits, it -> it.getOffset()));
        ArrayList<TextReplacement> result = new ArrayList<TextReplacement>();
        int lastOffset = 0;
        IParseResult parseResult = res.getParseResult();
        if (parseResult != null && (rootNode = parseResult.getRootNode()) != null) {
            for (ILeafNode leaf : rootNode.getLeafNodes()) {
                if (leaf.isHidden() && StringExtensions.isNullOrEmpty((String)leaf.getText().trim())) continue;
                ITextRegion leafRegion = leaf.getTextRegion();
                if (lastOffset >= offset && leafRegion.getOffset() <= offset + length && !offsets.contains(lastOffset)) {
                    result.add(new TextReplacement(lastOffset, leafRegion.getOffset() - lastOffset, "!!"));
                }
                lastOffset = leafRegion.getOffset() + leafRegion.getLength();
            }
        }
        return result;
    }
}

