/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.formatting.preferences;

import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtend.core.formatting2.XtendFormatterPreferenceKeys;
import org.eclipse.xtend.ide.formatting.preferences.AbstractProfileManager;
import org.eclipse.xtend.ide.formatting.preferences.FormatterModifyDialog;
import org.eclipse.xtend.ide.formatting.preferences.FormatterProfileStore;
import org.eclipse.xtend.ide.formatting.preferences.FormatterProfileVersioner;
import org.eclipse.xtend.ide.formatting.preferences.Messages;
import org.eclipse.xtend.ide.formatting.preferences.PreviewCode;
import org.eclipse.xtend.ide.formatting.preferences.XtendFormatterPreview;
import org.eclipse.xtend.ide.formatting.preferences.XtendPreviewFactory;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.preferences.PreferenceKeysProvider;

public abstract class FormatterConfigurationBlock
extends ProfileConfigurationBlock {
    @Inject
    private XtendPreviewFactory previewFactory;
    @Inject
    private FormatterModifyDialog.Factory formatterModifyDialogFactory;

    public FormatterConfigurationBlock(IProject project, PreferencesAccess access, String lastSaveLoadPathKey) {
        super(project, access, lastSaveLoadPathKey);
    }

    protected IProfileVersioner createProfileVersioner() {
        return new FormatterProfileVersioner();
    }

    protected ModifyDialog createModifyDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile) {
        return this.formatterModifyDialogFactory.create(shell, profile, profileManager, profileStore, newProfile, "", "");
    }

    protected void configurePreview(Composite composite, int numColumns, ProfileManager profileManager) {
        FormatterConfigurationBlock.createLabel((Composite)composite, (String)Messages.FormatterConfigurationBlock_XtendCodePreview, (int)numColumns);
        XtendFormatterPreview xtendPreview = this.previewFactory.createNewPreview(composite, PreviewCode.defaultPreviewText());
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        xtendPreview.getEditorViewer().getControl().setLayoutData((Object)gd);
        profileManager.addObserver(xtendPreview.getObserver());
        xtendPreview.doUpdate(profileManager.getSelected().getSettings());
    }

    protected abstract ProfileStore createProfileStore(IProfileVersioner var1);

    public static class Factory {
        @Inject
        @Named(value="languageName")
        private String xtendNodeID;
        @Inject
        MembersInjector<FormatterConfigurationBlock> injector;

        public ProfileConfigurationBlock create(IProject project, PreferencesAccess access, String lastSaveLoadPathKey) {
            FormatterConfigurationBlock result = new FormatterConfigurationBlock(project, access, lastSaveLoadPathKey){
                private static final String DEFUALT_PROFILE_KEY = "org.eclipse.xtend.ide.default.eclipse_profile";
                private static final int FORMATTER_SETTINGS_VERSION = 1;

                @Override
                protected ProfileStore createProfileStore(IProfileVersioner profileVersioner) {
                    return new FormatterProfileStore(profileVersioner, xtendNodeID);
                }

                protected ProfileManager createProfileManager(List profiles, IScopeContext context, PreferencesAccess access, IProfileVersioner profileVersioner) {
                    this.addBuiltinProfiles(profiles, profileVersioner);
                    String profVersionerkey = String.valueOf(FormatterProfileVersioner.PREFIX) + FormatterProfileVersioner.VERSION_KEY;
                    ArrayList<String> keys = new ArrayList<String>(this.getDefaultProfileSettings().keySet());
                    keys.add(profVersionerkey);
                    ProfileManager.KeySet[] keySet = new ProfileManager.KeySet[]{new ProfileManager.KeySet(xtendNodeID, keys)};
                    return new AbstractProfileManager(profiles, context, access, profileVersioner, keySet, DEFUALT_PROFILE_KEY, profVersionerkey){

                        @Override
                        protected String getNodeId() {
                            return xtendNodeID;
                        }

                        @Override
                        public ProfileManager.Profile getDefaultProfile() {
                            return this.getProfile(1.DEFUALT_PROFILE_KEY);
                        }
                    };
                }

                private List<ProfileManager.Profile> addBuiltinProfiles(List profiles, IProfileVersioner profileVersioner) {
                    ProfileManager.BuiltInProfile profile = new ProfileManager.BuiltInProfile(DEFUALT_PROFILE_KEY, Messages.FormatterConfigurationBlock_DefaultProfileLabel, this.getDefaultProfileSettings(), 1, profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
                    profiles.add(profile);
                    return profiles;
                }

                protected Map<String, String> getDefaultProfileSettings() {
                    Set keys = PreferenceKeysProvider.allConstantKeys((Class[])new Class[]{XtendFormatterPreferenceKeys.class});
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (PreferenceKey key : keys) {
                        hashMap.put(key.getId(), key.getDefaultValue());
                    }
                    return hashMap;
                }
            };
            this.injector.injectMembers((Object)result);
            return result;
        }
    }
}

