/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.impl;

public abstract class DatatypeRuleToken {
    public static final int INITIAL_OFFSET = -1;
    protected final StringBuilder buffer = new StringBuilder();
    protected int expectedOffset = -1;
    protected int startOffset = -1;

    protected DatatypeRuleToken() {
    }

    public void merge(DatatypeRuleToken token) {
        this.internalMerge(token.getText(), token.startOffset);
    }

    protected void internalMerge(String text, int offset) {
        if (text == null) {
            return;
        }
        if (this.startOffset == -1) {
            this.startOffset = offset;
        }
        if (this.expectedOffset != -1 && offset > this.expectedOffset) {
            this.buffer.append(' ');
        }
        this.buffer.append(text);
        this.expectedOffset = offset + text.length();
    }

    public String getText() {
        if (this.buffer.length() > 0) {
            return this.buffer.toString();
        }
        return null;
    }

    public void setText(String text) {
        this.buffer.replace(0, this.buffer.length(), text);
    }

    public int getExpectedOffset() {
        return this.expectedOffset;
    }

    public void setExpectedOffset(int expectedOffset) {
        this.expectedOffset = expectedOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append("{\n\t");
        result.append("startOffset: ").append(this.startOffset).append("\n\t");
        result.append("expectedOffset: ").append(this.expectedOffset).append("\n\t");
        result.append("bufferValue: '").append(this.buffer.toString()).append("'\n}");
        return result.toString();
    }
}

