/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.generator.trace.DefaultTraceURIConverter;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class DefaultUITraceURIConverter
extends DefaultTraceURIConverter {
    private static final Logger LOG = Logger.getLogger(DefaultUITraceURIConverter.class);
    @Inject
    private IStorage2UriMapper mapper;

    public URI getURIForTrace(XtextResource context) {
        ResourceSet rs = context.getResourceSet();
        if (!(rs instanceof XtextResourceSet) || !(((XtextResourceSet)rs).getClasspathURIContext() instanceof IJavaProject)) {
            return super.getURIForTrace(context);
        }
        IJavaProject javaProject = (IJavaProject)((XtextResourceSet)rs).getClasspathURIContext();
        try {
            return this.computeTraceURI(context.getURI(), javaProject);
        }
        catch (JavaModelException e) {
            LOG.error((Object)e);
            return super.getURIForTrace(context);
        }
    }

    public URI getURIForTrace(URI uri) {
        Iterator<Pair<IStorage, IProject>> storagesIterator;
        if (uri.isPlatform() && uri.segmentCount() > 1 && (storagesIterator = this.mapper.getStorages(uri).iterator()).hasNext()) {
            Pair<IStorage, IProject> candidate = storagesIterator.next();
            IProject project = (IProject)candidate.getSecond();
            try {
                IJavaProject javaProject;
                if (project.exists() && project.hasNature("org.eclipse.jdt.core.javanature") && (javaProject = JavaCore.create((IProject)project)) != null) {
                    return this.computeTraceURI(uri, javaProject);
                }
            }
            catch (JavaModelException e) {
                LOG.error((Object)e);
            }
            catch (CoreException e) {
                LOG.error((Object)e);
            }
        }
        return super.getURIForTrace(uri);
    }

    protected URI computeTraceURI(URI uri, IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI prefix;
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1 && this.isPrefix(prefix = URI.createPlatformResourceURI((String)root.getResource().getFullPath().addTrailingSeparator().toString(), (boolean)true), uri)) {
                return uri.deresolve(prefix).trimFragment().trimQuery();
            }
            ++n2;
        }
        return super.getURIForTrace(uri);
    }
}

