/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionUtil {
    public XExpression findSelectedExpression(XtextResource resource, ITextSelection selection) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)selection.getOffset());
            if (node != null && (node.isHidden() || this.isBeginOfASymbol((INode)node, selection))) {
                node = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)(selection.getOffset() - 1));
            }
            if (node != null) {
                EObject currentSemanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                while (!this.nodeContainsSelection((INode)node, selection) || !(currentSemanticElement instanceof XExpression)) {
                    if ((node = node.getParent()) == null) {
                        return null;
                    }
                    currentSemanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                }
                return (XExpression)currentSemanticElement;
            }
        }
        return null;
    }

    public List<XExpression> findSelectedSiblingExpressions(XtextResource resource, ITextSelection selection) {
        ITextSelection trimmedSelection = this.trimSelection(resource, selection);
        XExpression selectedExpression = this.findSelectedExpression(resource, trimmedSelection);
        if (selectedExpression instanceof XBlockExpression) {
            ArrayList selectedExpressions = Lists.newArrayList();
            for (XExpression subExpression : ((XBlockExpression)selectedExpression).getExpressions()) {
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)subExpression);
                if (node == null || !this.nodeIntersectsWithSelection(trimmedSelection, node)) continue;
                selectedExpressions.add(subExpression);
            }
            return selectedExpressions;
        }
        if (selectedExpression == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(selectedExpression);
    }

    protected ITextSelection trimSelection(XtextResource resource, ITextSelection selection) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            String model = parseResult.getRootNode().getText();
            String selectedText = model.substring(selection.getOffset(), selection.getOffset() + selection.getLength());
            String trimmedSelection = selectedText.trim();
            return new TextSelection(selection.getOffset() + selectedText.indexOf(trimmedSelection), trimmedSelection.length());
        }
        return null;
    }

    protected boolean isBeginOfASymbol(INode node, ITextSelection selection) {
        return node.getOffset() == selection.getOffset() && node.getLength() > 0 && !Character.isLetterOrDigit(node.getText().charAt(0)) && node.getText().charAt(0) != '[' && node.getText().charAt(0) != '(';
    }

    protected boolean nodeContainsSelection(INode node, ITextSelection selection) {
        return node.getOffset() <= selection.getOffset() && node.getOffset() + node.getLength() >= selection.getOffset() + selection.getLength();
    }

    protected boolean nodeIntersectsWithSelection(ITextSelection trimmedSelection, ICompositeNode node) {
        return node.getOffset() <= trimmedSelection.getOffset() + trimmedSelection.getLength() && node.getOffset() + node.getLength() >= trimmedSelection.getOffset();
    }

    public XExpression findSuccessorExpressionForVariableDeclaration(EObject expression) {
        EObject eContainer = expression.eContainer();
        if (eContainer == null) {
            return null;
        }
        if (expression instanceof XExpression) {
            if (eContainer instanceof XBlockExpression) {
                return (XExpression)expression;
            }
            if (this.isBlockInsertable(eContainer, expression)) {
                return (XExpression)expression;
            }
        }
        return this.findSuccessorExpressionForVariableDeclaration(eContainer);
    }

    protected boolean isBlockInsertable(EObject eContainer, EObject expression) {
        EReference ref = expression.eContainmentFeature();
        return ref == XbasePackage.Literals.XCLOSURE__EXPRESSION || ref == XbasePackage.Literals.XIF_EXPRESSION__THEN || ref == XbasePackage.Literals.XIF_EXPRESSION__ELSE || ref == XbasePackage.Literals.XCASE_PART__THEN || ref == XbasePackage.Literals.XSWITCH_EXPRESSION__DEFAULT || ref == XbasePackage.Literals.XFOR_LOOP_EXPRESSION__EACH_EXPRESSION || ref == XbasePackage.Literals.XABSTRACT_WHILE_EXPRESSION__BODY || ref == XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__EXPRESSION || ref == XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__FINALLY_EXPRESSION || ref == XbasePackage.Literals.XCATCH_CLAUSE__EXPRESSION;
    }
}

