/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.templates;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XtextTemplateContextTypeRegistry
extends ContextTypeRegistry {
    private final ContextTypeIdHelper helper;

    @Inject
    public XtextTemplateContextTypeRegistry(IGrammarAccess grammarAccess, Provider<XtextTemplateContextType> ctxTypeProvider, ContextTypeIdHelper helper) {
        this.helper = helper;
        this.registerContextTypes(grammarAccess, ctxTypeProvider);
    }

    protected void registerContextTypes(IGrammarAccess grammarAccess, Provider<XtextTemplateContextType> ctxTypeProvider) {
        List parserRules = GrammarUtil.allParserRules((Grammar)grammarAccess.getGrammar());
        ArrayList allContextTypes = Lists.newArrayList();
        for (ParserRule parserRule : parserRules) {
            XtextTemplateContextType type = (XtextTemplateContextType)ctxTypeProvider.get();
            type.setName(parserRule.getName());
            type.setId(this.getId(parserRule));
            allContextTypes.add(type);
            List keywords = EcoreUtil2.getAllContentsOfType((EObject)parserRule, Keyword.class);
            for (Keyword keyword : keywords) {
                String value = this.getId(keyword);
                if (value == null) continue;
                type = (XtextTemplateContextType)ctxTypeProvider.get();
                type.setName("Keyword '" + keyword.getValue() + "'");
                type.setId(value);
                allContextTypes.add(type);
            }
        }
        Collections.sort(allContextTypes);
        for (XtextTemplateContextType templateContextType : allContextTypes) {
            this.addContextType(templateContextType);
        }
    }

    public String getId(Keyword k) {
        return this.helper.getId((AbstractElement)k);
    }

    public String getId(ParserRule parserRule) {
        return this.helper.getId((AbstractRule)parserRule);
    }

    public ContextTypeIdHelper getHelper() {
        return this.helper;
    }
}

