/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.ide.editor.OverrideIndicatorAnnotation;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.SchedulingRuleFactory;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;

public class OverrideIndicatorModelListener
extends IXtextEditorCallback.NullImpl
implements IXtextModelListener {
    private static final Logger LOG = Logger.getLogger(OverrideIndicatorModelListener.class);
    public static final String JOB_NAME = "Override Indicator Updater";
    private static ISchedulingRule SCHEDULING_RULE = SchedulingRuleFactory.INSTANCE.newSequence();
    private volatile XtextEditor xtextEditor;
    private Set<Annotation> overrideIndicatorAnnotations = Sets.newHashSet();
    private Job currentJob;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private IBatchTypeResolver typeResolver;

    public void afterCreatePartControl(XtextEditor xtextEditor) {
        this.xtextEditor = xtextEditor;
        this.installModelListener(xtextEditor);
    }

    public void afterSetInput(XtextEditor xtextEditor) {
        this.installModelListener(xtextEditor);
    }

    public void beforeDispose(XtextEditor xtextEditor) {
        if (this.xtextEditor != null) {
            this.xtextEditor = null;
        }
    }

    public void modelChanged(XtextResource resource) {
        this.asyncUpdateAnnotationModel();
    }

    private void asyncUpdateAnnotationModel() {
        if (this.currentJob != null) {
            this.currentJob.cancel();
        }
        this.currentJob = new Job(JOB_NAME){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    return OverrideIndicatorModelListener.this.updateAnnotationModel(monitor);
                }
                catch (OperationCanceledException e) {
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error updating override indicator", (Throwable)e);
                    return Status.OK_STATUS;
                }
            }
        };
        this.currentJob.setRule(SCHEDULING_RULE);
        this.currentJob.setPriority(50);
        this.currentJob.setSystem(true);
        this.currentJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus updateAnnotationModel(IProgressMonitor monitor) {
        XtextEditor locXtextEditor = this.xtextEditor;
        if (locXtextEditor == null || locXtextEditor.getDocument() == null || locXtextEditor.getInternalSourceViewer().getAnnotationModel() == null) {
            return Status.OK_STATUS;
        }
        IXtextDocument xtextDocument = locXtextEditor.getDocument();
        IAnnotationModel annotationModel = locXtextEditor.getInternalSourceViewer().getAnnotationModel();
        Map annotationToPosition = (Map)xtextDocument.readOnly((IUnitOfWork)new CancelableUnitOfWork<Map<Annotation, Position>, XtextResource>(){

            public Map<Annotation, Position> exec(XtextResource xtextResource, CancelIndicator cancelIndicator) {
                if (xtextResource == null) {
                    return Collections.emptyMap();
                }
                return OverrideIndicatorModelListener.this.createOverrideIndicatorAnnotationMap(xtextResource, cancelIndicator);
            }
        });
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (annotationModel instanceof IAnnotationModelExtension) {
            Object lockObject;
            IAnnotationModelExtension annotationModelExtension = (IAnnotationModelExtension)annotationModel;
            Object object = lockObject = this.getLockObject(annotationModel);
            synchronized (object) {
                annotationModelExtension.replaceAnnotations(this.overrideIndicatorAnnotations.toArray(new Annotation[this.overrideIndicatorAnnotations.size()]), annotationToPosition);
            }
            this.overrideIndicatorAnnotations = annotationToPosition.keySet();
        }
        return Status.OK_STATUS;
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    protected Map<Annotation, Position> createOverrideIndicatorAnnotationMap(XtextResource xtextResource, CancelIndicator cancelIndicator) {
        EList contents = xtextResource.getContents();
        if (contents.isEmpty()) {
            return Maps.newHashMap();
        }
        EObject eObject = (EObject)contents.get(0);
        if (!(eObject instanceof XtendFile)) {
            return Maps.newHashMap();
        }
        XtendFile xtendFile = (XtendFile)eObject;
        HashMap annotationToPosition = Maps.newHashMap();
        for (XtendFunction xtendFunction : this.getXtendFunctions(xtendFile)) {
            if (cancelIndicator.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!xtendFunction.isOverride()) continue;
            this.typeResolver.resolveTypes((EObject)xtendFunction);
            ICompositeNode node = NodeModelUtils.getNode((EObject)xtendFunction);
            JvmOperation inferredOperation = this.associations.getDirectlyInferredOperation(xtendFunction);
            if (inferredOperation == null) continue;
            JvmOperation jvmOperation = this.overrideHelper.findOverriddenOperation(inferredOperation);
            if (node == null || jvmOperation == null) continue;
            boolean overwriteIndicator = this.isOverwriteIndicator(jvmOperation);
            String text = (overwriteIndicator ? "overrides " : "implements ") + jvmOperation.getQualifiedName();
            node = (INode)Iterables.getFirst((Iterable)NodeModelUtils.findNodesForFeature((EObject)xtendFunction, (EStructuralFeature)XtendPackage.eINSTANCE.getXtendFunction_Name()), (Object)node);
            annotationToPosition.put(new OverrideIndicatorAnnotation(overwriteIndicator, text, xtextResource.getURIFragment((EObject)xtendFunction)), new Position(node.getOffset()));
        }
        return annotationToPosition;
    }

    private Iterable<XtendFunction> getXtendFunctions(XtendFile xtendFile) {
        ArrayList xtendFunctions = Lists.newArrayList();
        TreeIterator i = xtendFile.eAllContents();
        while (i.hasNext()) {
            EObject next = (EObject)i.next();
            if (!(next instanceof XtendFunction)) continue;
            xtendFunctions.add((XtendFunction)next);
        }
        return xtendFunctions;
    }

    protected boolean isOverwriteIndicator(JvmOperation jvmOperation) {
        return !jvmOperation.isAbstract();
    }

    private void installModelListener(XtextEditor xtextEditor) {
        if (xtextEditor.getDocument() != null) {
            this.asyncUpdateAnnotationModel();
            xtextEditor.getDocument().addModelListener((IXtextModelListener)this);
        }
    }
}

