/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.ui.wizard.IProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.ui.wizard.Messages;

public abstract class AbstractProjectCreator
extends WorkspaceModifyOperation
implements IProjectCreator {
    private IFile result;
    private IProjectInfo projectInfo;
    @Inject
    @Named(value="file.extensions")
    private String fileExtension;

    @Override
    public IFile getResult() {
        return this.result;
    }

    protected void setResult(IFile result) {
        this.result = result;
    }

    @Override
    public void setProjectInfo(IProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    protected IProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    protected String getEncoding() throws CoreException {
        return ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getCreateModelProjectMessage(), (int)2);
        try {
            IProject project = this.createProject((IProgressMonitor)subMonitor.newChild(1));
            if (project == null) {
                return;
            }
            this.enhanceProject(project, (IProgressMonitor)subMonitor.newChild(1));
            IFile modelFile = this.getModelFile(project);
            this.setResult(modelFile);
        }
        finally {
            subMonitor.done();
        }
    }

    protected String getCreateModelProjectMessage() {
        return String.valueOf(Messages.AbstractProjectCreator_0) + this.getProjectInfo().getProjectName();
    }

    protected IFile getModelFile(IProject project) throws CoreException {
        IFolder srcFolder = project.getFolder(this.getModelFolderName());
        final String expectedExtension = this.getPrimaryModelFileExtension();
        final IFile[] result = new IFile[1];
        srcFolder.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (1 == resource.getType() && expectedExtension.equals(resource.getFileExtension())) {
                    result[0] = (IFile)resource;
                    return false;
                }
                return 2 == resource.getType();
            }
        });
        return result[0];
    }

    protected IProject createProject(IProgressMonitor monitor) {
        ProjectFactory factory = this.createProjectFactory();
        this.configureProjectBuilder(factory);
        return factory.createProject(monitor, null);
    }

    @Deprecated
    protected ProjectFactory configureProjectBuilder(ProjectFactory factory) {
        return this.configureProjectFactory(factory);
    }

    protected ProjectFactory configureProjectFactory(ProjectFactory factory) {
        factory.setProjectName(this.getProjectInfo().getProjectName());
        factory.addFolders(this.getAllFolders());
        factory.addReferencedProjects(this.getReferencedProjects());
        factory.addProjectNatures(this.getProjectNatures());
        factory.addBuilderIds(this.getBuilders());
        return factory;
    }

    protected abstract ProjectFactory createProjectFactory();

    protected void enhanceProject(IProject project, IProgressMonitor monitor) throws CoreException {
    }

    protected String getPrimaryModelFileExtension() {
        String result = this.fileExtension;
        int idx = result.indexOf(44);
        if (idx > 0) {
            return result.substring(0, idx).trim();
        }
        return result;
    }

    protected abstract String getModelFolderName();

    protected abstract List<String> getAllFolders();

    protected List<IProject> getReferencedProjects() {
        return Collections.emptyList();
    }

    protected String[] getProjectNatures() {
        return new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", "org.eclipse.xtext.ui.shared.xtextNature"};
    }

    protected String[] getBuilders() {
        return new String[]{"org.eclipse.jdt.core.javabuilder", "org.eclipse.pde.ManifestBuilder", "org.eclipse.pde.SchemaBuilder", "org.eclipse.xtext.ui.shared.xtextBuilder"};
    }
}

