/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.AbstractOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.EStructuralFeatureNode;
import org.eclipse.xtext.ui.editor.outline.impl.IOutlineTreeStructureProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DefaultOutlineTreeProvider
implements IOutlineTreeStructureProvider,
IOutlineTreeProvider,
IOutlineTreeProvider.Cancelable {
    @Inject
    protected ILabelProvider labelProvider;
    @Inject
    protected ILocationInFileProvider locationInFileProvider;
    private CancelIndicator cancelIndicator = CancelIndicator.NullImpl;
    protected PolymorphicDispatcher<Void> createChildrenDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_createChildren", (int)2, (int)2, (Object)this);
    protected PolymorphicDispatcher<Void> createNodeDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_createNode", (int)2, (int)2, (Object)this);
    protected PolymorphicDispatcher<Object> textDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_text", (int)1, (int)1, (Object)this);
    protected PolymorphicDispatcher<Image> imageDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_image", (int)1, (int)1, (Object)this);
    protected PolymorphicDispatcher<Boolean> isLeafDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_isLeaf", (int)1, (int)1, (Object)this);

    public DefaultOutlineTreeProvider() {
    }

    public DefaultOutlineTreeProvider(ILabelProvider labelProvider, ILocationInFileProvider locationInFileProvider) {
        this.labelProvider = labelProvider;
        this.locationInFileProvider = locationInFileProvider;
    }

    @Override
    public IOutlineNode createRoot(IXtextDocument document) {
        DocumentRootNode documentNode = new DocumentRootNode(this.labelProvider.getImage((Object)document), (Object)this.labelProvider.getText((Object)document), document, (IOutlineTreeStructureProvider)this);
        documentNode.setTextRegion((ITextRegion)new TextRegion(0, document.getLength()));
        return documentNode;
    }

    @Override
    public IOutlineNode createRoot(IXtextDocument document, CancelIndicator cancelIndicator) {
        try {
            this.cancelIndicator = cancelIndicator;
            IOutlineNode iOutlineNode = this.createRoot(document);
            return iOutlineNode;
        }
        finally {
            this.cancelIndicator = CancelIndicator.NullImpl;
        }
    }

    protected void checkCanceled() {
        if (this.cancelIndicator.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public void createChildren(IOutlineNode parent, EObject modelElement) {
        this.checkCanceled();
        if (modelElement != null && parent.hasChildren()) {
            this.createChildrenDispatcher.invoke(new Object[]{parent, modelElement});
        }
    }

    protected void _createChildren(DocumentRootNode parentNode, EObject modelElement) {
        this.createNode(parentNode, modelElement);
    }

    protected void _createChildren(IOutlineNode parentNode, EObject modelElement) {
        for (EObject childElement : modelElement.eContents()) {
            this.createNode(parentNode, childElement);
        }
    }

    protected void _createChildren(EStructuralFeatureNode parentNode, EObject modelElement) {
        Object values = modelElement.eGet(parentNode.getEStructuralFeature());
        if (values != null) {
            if (parentNode.getEStructuralFeature().isMany()) {
                for (EObject value : EcoreUtil2.typeSelect((List)((List)values), EObject.class)) {
                    this.createNode(parentNode, value);
                }
            } else if (values instanceof EObject) {
                this.createNode(parentNode, (EObject)values);
            }
        }
    }

    protected void createNode(IOutlineNode parent, EObject modelElement) {
        this.checkCanceled();
        this.createNodeDispatcher.invoke(new Object[]{parent, modelElement});
    }

    protected void _createNode(DocumentRootNode parentNode, EObject modelElement) {
        Object text = this.textDispatcher.invoke(new Object[]{modelElement});
        if (text == null) {
            text = modelElement.eResource().getURI().trimFileExtension().lastSegment();
        }
        this.createEObjectNode(parentNode, modelElement, (Image)this.imageDispatcher.invoke(new Object[]{modelElement}), text, (Boolean)this.isLeafDispatcher.invoke(new Object[]{modelElement}));
    }

    protected void _createNode(IOutlineNode parentNode, EObject modelElement) {
        Object text = this.textDispatcher.invoke(new Object[]{modelElement});
        boolean isLeaf = (Boolean)this.isLeafDispatcher.invoke(new Object[]{modelElement});
        if (text == null && isLeaf) {
            return;
        }
        Image image = (Image)this.imageDispatcher.invoke(new Object[]{modelElement});
        this.createEObjectNode(parentNode, modelElement, image, text, isLeaf);
    }

    protected EObjectNode createEObjectNode(IOutlineNode parentNode, EObject modelElement) {
        return this.createEObjectNode(parentNode, modelElement, (Image)this.imageDispatcher.invoke(new Object[]{modelElement}), this.textDispatcher.invoke(new Object[]{modelElement}), (Boolean)this.isLeafDispatcher.invoke(new Object[]{modelElement}));
    }

    protected boolean isLocalElement(IOutlineNode node, final EObject element) {
        if (node instanceof AbstractOutlineNode) {
            return (Boolean)((AbstractOutlineNode)node).getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

                public Boolean exec(XtextResource state) throws Exception {
                    if (element.eResource() == state) {
                        return true;
                    }
                    return false;
                }
            });
        }
        return true;
    }

    protected EObjectNode createEObjectNode(IOutlineNode parentNode, EObject modelElement, Image image, Object text, boolean isLeaf) {
        EObjectNode eObjectNode = new EObjectNode(modelElement, parentNode, image, text, isLeaf);
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)modelElement);
        if (parserNode != null) {
            eObjectNode.setTextRegion(parserNode.getTextRegion());
        }
        if (this.isLocalElement(parentNode, modelElement)) {
            eObjectNode.setShortTextRegion(this.locationInFileProvider.getSignificantTextRegion(modelElement));
        }
        return eObjectNode;
    }

    protected boolean _isLeaf(final EObject modelElement) {
        return !Iterables.any((Iterable)modelElement.eClass().getEAllContainments(), (Predicate)new Predicate<EReference>(){

            public boolean apply(EReference containmentRef) {
                return modelElement.eIsSet((EStructuralFeature)containmentRef);
            }
        });
    }

    protected EStructuralFeatureNode createEStructuralFeatureNode(IOutlineNode parentNode, EObject owner, EStructuralFeature feature, Image image, Object text, boolean isLeaf) {
        boolean isFeatureSet = owner.eIsSet(feature);
        EStructuralFeatureNode eStructuralFeatureNode = new EStructuralFeatureNode(owner, feature, parentNode, image, text, isLeaf || !isFeatureSet);
        if (isFeatureSet) {
            int numValues;
            ITextRegion fullTextRegion;
            ITextRegion region = this.locationInFileProvider.getFullTextRegion(owner, feature, 0);
            if (feature.isMany() && (fullTextRegion = this.locationInFileProvider.getFullTextRegion(owner, feature, (numValues = ((Collection)owner.eGet(feature)).size()) - 1)) != null) {
                region = region.merge(fullTextRegion);
            }
            eStructuralFeatureNode.setTextRegion(region);
        }
        return eStructuralFeatureNode;
    }

    protected void _createChildren(Object parent, Object element) {
    }

    protected void _createNode(Object parentObject, EObject modelElement) {
        throw new IllegalArgumentException("Could not find method createNode(" + this.nullSafeClassName(parentObject) + "," + this.nullSafeClassName(modelElement));
    }

    protected boolean _isLeaf(Object modelElement) {
        return true;
    }

    protected Object _text(Object modelElement) {
        if (this.labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            return ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider).getStyledText(modelElement);
        }
        return this.labelProvider.getText(modelElement);
    }

    protected Image _image(Object modelElement) {
        return this.labelProvider.getImage(modelElement);
    }

    protected String nullSafeClassName(Object object) {
        return object != null ? object.getClass().getName() : "null";
    }
}

