/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.navigation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.common.types.xtext.ui.TypeAwareHyperlinkHelper;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.hyperlinking.AbstractHyperlink;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.imports.StaticallyImportedMemberProvider;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.ui.navigation.JvmImplementationOpener;
import org.eclipse.xtext.xbase.ui.navigation.XbaseImplementatorsHyperlink;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

public class XbaseHyperLinkHelper
extends TypeAwareHyperlinkHelper
implements ISourceViewerAware {
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private StaticallyImportedMemberProvider staticImpMemberProvider;
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private JvmImplementationOpener implOpener;
    protected ISourceViewer sourceViewer;

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public IHyperlink[] createHyperlinksByOffset(XtextResource resource, int offset, boolean createMultipleHyperlinks) {
        ArrayList links = Lists.newArrayList();
        XbaseHyperlinkAcceptor acceptor = new XbaseHyperlinkAcceptor(links, createMultipleHyperlinks);
        super.createHyperlinksByOffset(resource, offset, (IHyperlinkAcceptor)acceptor);
        INode crossRefNode = this.getEObjectAtOffsetHelper().getCrossReferenceNode(resource, (ITextRegion)new TextRegion(offset, 0));
        if (crossRefNode == null) {
            this.createHyperlinksByOffset(resource, offset, (IHyperlinkAcceptor)acceptor);
        } else {
            this.createHyperlinksForCrossRef(resource, crossRefNode, (IHyperlinkAcceptor)acceptor);
        }
        if (!links.isEmpty()) {
            return (IHyperlink[])Iterables.toArray((Iterable)links, IHyperlink.class);
        }
        return null;
    }

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        ITextRegion textRegion;
        XImportDeclaration importDeclaration;
        EObject element = this.getEObjectAtOffsetHelper().resolveElementAt(resource, offset);
        if (element instanceof XImportDeclaration && (importDeclaration = (XImportDeclaration)element).isStatic() && !importDeclaration.isWildcard() && (textRegion = this.getTextRegion(importDeclaration, offset)) != null) {
            Region region = new Region(textRegion.getOffset(), textRegion.getLength());
            Iterable _allFeatures = this.staticImpMemberProvider.getAllFeatures(importDeclaration);
            for (JvmFeature feature : _allFeatures) {
                this.createHyperlinksTo(resource, region, (EObject)feature, acceptor);
            }
        }
        super.createHyperlinksByOffset(resource, offset, acceptor);
        if (this.canShowMany(acceptor)) {
            ILeafNode node;
            if (element instanceof XVariableDeclaration) {
                XVariableDeclaration variableDeclaration = (XVariableDeclaration)element;
                node = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset);
                if (this.isNameNode(element, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, node) && variableDeclaration.getType() == null) {
                    this.addOpenInferredTypeHyperlink(resource, (JvmIdentifiableElement)variableDeclaration, node, acceptor);
                }
            }
            if (element instanceof JvmFormalParameter) {
                JvmFormalParameter param = (JvmFormalParameter)element;
                node = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset);
                if (this.isNameNode(element, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, node) && param.getParameterType() == null) {
                    this.addOpenInferredTypeHyperlink(resource, (JvmIdentifiableElement)param, node, acceptor);
                }
            }
        }
    }

    protected boolean canShowMany(IHyperlinkAcceptor acceptor) {
        if (acceptor instanceof XbaseHyperlinkAcceptor) {
            return ((XbaseHyperlinkAcceptor)acceptor).canShowMany();
        }
        return true;
    }

    protected void addOpenInferredTypeHyperlink(XtextResource resource, JvmIdentifiableElement typedElement, ILeafNode node, final IHyperlinkAcceptor acceptor) {
        IResolvedTypes resolveTypes = this.typeResolver.resolveTypes((Resource)resource);
        final LightweightTypeReference type = resolveTypes.getActualType(typedElement);
        if (type != null && !type.isUnknown() && type.getType() != null) {
            this.createHyperlinksTo(resource, new Region(node.getOffset(), node.getLength()), (EObject)type.getType(), new IHyperlinkAcceptor(){

                public void accept(IHyperlink hyperlink) {
                    if (hyperlink instanceof AbstractHyperlink) {
                        AbstractHyperlink abstractHyperlink = (AbstractHyperlink)hyperlink;
                        abstractHyperlink.setHyperlinkText("Open Inferred Type - " + type.getSimpleName());
                        abstractHyperlink.setTypeLabel("SHOW_ALWAYS");
                    }
                    acceptor.accept(hyperlink);
                }
            });
        }
    }

    protected boolean isNameNode(EObject element, EStructuralFeature feature, ILeafNode node) {
        List nameNode = NodeModelUtils.findNodesForFeature((EObject)element, (EStructuralFeature)feature);
        for (INode iNode : nameNode) {
            if (iNode.getOffset() > node.getOffset() || iNode.getLength() < node.getLength()) continue;
            return true;
        }
        return false;
    }

    protected void createHyperlinksForCrossRef(XtextResource resource, INode crossRefNode, final IHyperlinkAcceptor acceptor) {
        EObject containedElementAt = this.getEObjectAtOffsetHelper().resolveContainedElementAt(resource, crossRefNode.getOffset());
        if (containedElementAt instanceof XAbstractFeatureCall) {
            LightweightTypeReference typeReference;
            IResolvedTypes resolveTypes = this.typeResolver.resolveTypes((Resource)resource);
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)containedElementAt;
            final JvmIdentifiableElement targetElement = featureCall.getFeature();
            if (targetElement instanceof JvmType || featureCall.getFeature() instanceof JvmEnumerationLiteral) {
                return;
            }
            IJavaElement javaElement = this.javaElementFinder.findExactElementFor(targetElement);
            if (this.sourceViewer != null && javaElement != null && javaElement.getElementType() == 9 && this.canBeOverridden((IMethod)javaElement)) {
                acceptor.accept((IHyperlink)new XbaseImplementatorsHyperlink(javaElement, (IRegion)new Region(crossRefNode.getOffset(), crossRefNode.getLength()), (ITextViewer)this.sourceViewer, this.implOpener));
            }
            if ((typeReference = resolveTypes.getActualType((XExpression)featureCall)) == null || typeReference.isPrimitive() || typeReference.isPrimitiveVoid()) {
                return;
            }
            final JvmType type = typeReference.getType();
            if (type != null) {
                this.createHyperlinksTo(resource, crossRefNode, (EObject)type, new IHyperlinkAcceptor(){

                    public void accept(IHyperlink hyperlink) {
                        if (hyperlink instanceof AbstractHyperlink) {
                            String target = this.labelForTargetElement(targetElement);
                            ((AbstractHyperlink)hyperlink).setHyperlinkText("Open " + target + " Type - " + type.getSimpleName());
                        }
                        acceptor.accept(hyperlink);
                    }

                    private String labelForTargetElement(JvmIdentifiableElement targetElement2) {
                        String target = "Return";
                        if (targetElement2 instanceof JvmField) {
                            target = "Field";
                        } else if (targetElement2 instanceof JvmFormalParameter) {
                            target = targetElement2.eContainer() instanceof XSwitchExpression || targetElement2.eContainer() instanceof XForLoopExpression ? "Variable" : "Parameter";
                        } else if (targetElement2 instanceof XVariableDeclaration) {
                            target = "Variable";
                        }
                        return target;
                    }
                });
            }
        }
    }

    protected boolean canBeOverridden(IMethod method) {
        try {
            return !JdtFlags.isPrivate((IMember)method) && !JdtFlags.isStatic((IMember)method) && !JdtFlags.isFinal((IMember)method) && !JdtFlags.isFinal((IMember)method.getDeclaringType()) && !method.isConstructor();
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
            return false;
        }
    }

    protected void createHyperlinksTo(XtextResource resource, INode node, EObject target, IHyperlinkAcceptor acceptor) {
        EObject semanticObj = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        if (semanticObj instanceof XImportDeclaration) {
            if (((XImportDeclaration)semanticObj).isStatic()) {
                ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion(semanticObj, (EStructuralFeature)XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, 0);
                int _offset = textRegion.getOffset();
                int _length = textRegion.getLength();
                Region region = new Region(_offset, _length);
                this.createHyperlinksTo(resource, region, target, acceptor);
            }
        } else if (semanticObj instanceof XAbstractFeatureCall && target instanceof JvmType) {
            XAbstractFeatureCall casted = (XAbstractFeatureCall)semanticObj;
            while (casted.isPackageFragment()) {
                casted = (XAbstractFeatureCall)casted.eContainer();
            }
            if (casted.isTypeLiteral()) {
                ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion((EObject)casted);
                Region jfaceRegion = new Region(textRegion.getOffset(), textRegion.getLength());
                this.createHyperlinksTo(resource, jfaceRegion, target, acceptor);
                return;
            }
        }
        super.createHyperlinksTo(resource, node, target, acceptor);
    }

    private ITextRegion getTextRegion(XImportDeclaration it, int offset) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)it, (EStructuralFeature)XtypePackage.Literals.XIMPORT_DECLARATION__MEMBER_NAME);
        for (INode node : nodes) {
            ITextRegion textRegion = node.getTextRegion();
            if (!textRegion.contains(offset)) continue;
            return textRegion;
        }
        return null;
    }

    public IBatchTypeResolver getBatchTypeResolver() {
        return this.typeResolver;
    }

    protected static class XbaseHyperlinkAcceptor
    extends HyperlinkHelper.HyperlinkAcceptor {
        private boolean canShowMany;

        public XbaseHyperlinkAcceptor(List<IHyperlink> links, boolean canShowMany) {
            super(links);
            this.canShowMany = canShowMany;
        }

        public boolean canShowMany() {
            return this.canShowMany;
        }
    }
}

