/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.debug;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.idea.lang.XtendLanguage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.psi.impl.LeafXtextPsiElement;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.XbasePackage;

public class XtendSourcePositionProvider
extends SourcePositionProvider {
    @Inject
    private IScopeProvider scopeProvider;

    public XtendSourcePositionProvider() {
        XtendLanguage.INSTANCE.injectMembers((Object)this);
    }

    protected SourcePosition computeSourcePosition(NodeDescriptor descriptor, Project project, DebuggerContextImpl context, boolean nearest) {
        String _name = descriptor.getName();
        return this.getOriginalIfExists(context, _name);
    }

    protected SourcePosition getOriginalIfExists(DebuggerContextImpl context, String name) {
        PsiElement ele = context.getContextElement();
        if (ele instanceof LeafXtextPsiElement) {
            QualifiedName _create;
            INode _iNode = ((LeafXtextPsiElement)ele).getINode();
            EObject eobj = _iNode.getSemanticElement();
            boolean _equals = Objects.equal((Object)eobj, null);
            if (_equals) {
                return null;
            }
            IScope scope = this.scopeProvider.getScope(eobj, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
            IEObjectDescription element = scope.getSingleElement(_create = QualifiedName.create((String)name));
            if (!Objects.equal((Object)element, null) && Objects.equal((Object)element.getEObjectOrProxy().eResource(), (Object)eobj.eResource())) {
                boolean _notEquals;
                EObject _eObjectOrProxy = element.getEObjectOrProxy();
                ICompositeNode node = NodeModelUtils.getNode((EObject)_eObjectOrProxy);
                boolean bl = _notEquals = !Objects.equal((Object)node, null);
                if (_notEquals) {
                    int offset = node.getOffset();
                    BaseXtextFile _xtextFile = ((LeafXtextPsiElement)ele).getXtextFile();
                    return SourcePosition.createFromOffset((PsiFile)_xtextFile, (int)offset);
                }
            }
        }
        return null;
    }
}

