/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.macro;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtext.idea.resource.ModuleProvider;
import org.eclipse.xtext.idea.util.FilteringClassLoader;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class IdeaProcessorProvider
extends ProcessorInstanceForJvmTypeProvider {
    private static final Set<String> MACRO_PACKAGE_NAMES = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"org.eclipse.xtend.lib.macro", "org.eclipse.xtend2.lib", "org.eclipse.xtext.xbase.lib", "com.google.common"}));

    public ClassLoader getClassLoader(EObject ctx) {
        URL[] _urls = this.getUrls(ctx);
        FilteringClassLoader _macroClassLoader = this.getMacroClassLoader();
        return new URLClassLoader(_urls, (ClassLoader)_macroClassLoader);
    }

    protected FilteringClassLoader getMacroClassLoader() {
        ClassLoader _classLoader = TransformationContext.class.getClassLoader();
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(final String name) {
                Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                    public Boolean apply(String packageName) {
                        return name.startsWith(packageName);
                    }
                };
                return IterableExtensions.exists((Iterable)MACRO_PACKAGE_NAMES, (Functions.Function1)_function);
            }
        };
        return new FilteringClassLoader(_classLoader, (Functions.Function1)_function);
    }

    protected URL[] getUrls(EObject context) {
        Resource _eResource = context.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        Module _findModule = ModuleProvider.findModule((ResourceSet)_resourceSet);
        OrderEnumerator _orderEntries = OrderEnumerator.orderEntries((Module)_findModule);
        OrderEnumerator _recursively = _orderEntries.recursively();
        OrderRootsEnumerator _classes = _recursively.classes();
        PathsList _pathsList = _classes.getPathsList();
        List _virtualFiles = _pathsList.getVirtualFiles();
        Functions.Function1<VirtualFile, URL> _function = new Functions.Function1<VirtualFile, URL>(){

            public URL apply(VirtualFile it) {
                try {
                    String _path = it.getPath();
                    File _file = new File(_path);
                    URI _uRI = _file.toURI();
                    return _uRI.toURL();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return (URL[])Conversions.unwrapArray((Object)ListExtensions.map((List)_virtualFiles, (Functions.Function1)_function), URL.class);
    }
}

