/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.macro.XAnnotationExtensions;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.idea.resource.ModuleProvider;
import org.eclipse.xtext.idea.resource.VirtualFileURIUtil;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xtype.XtypePackage;

public class XtendIdeaValidator
extends AbstractDeclarativeValidator {
    @Inject
    @Extension
    private XAnnotationExtensions _xAnnotationExtensions;

    protected List<EPackage> getEPackages() {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EPackage[]{TypesPackage.eINSTANCE, XtypePackage.eINSTANCE, XbasePackage.eINSTANCE, XAnnotationsPackage.eINSTANCE, XtendPackage.eINSTANCE}));
    }

    @Check
    public void checkAnnotationInSameModule(XAnnotation annotation) {
        JvmType annotationType;
        boolean _isSameModule;
        boolean _isProcessed = this._xAnnotationExtensions.isProcessed(annotation);
        if (_isProcessed && (_isSameModule = this.isSameModule(annotation, annotationType = annotation.getAnnotationType()))) {
            this.error("The referenced active annotation cannot be used from within the same module.", (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, -1, "org.eclipse.xtend.core.validation.IssueCodes.active_annotation_in_same_project", new String[0]);
        }
    }

    protected boolean isSameModule(final XAnnotation annotation, final JvmType annotationType) {
        Application _application = ApplicationManager.getApplication();
        Computable<Boolean> _function = new Computable<Boolean>(){

            public Boolean compute() {
                GlobalSearchScope _moduleScope;
                String _qualifiedName;
                Module module = XtendIdeaValidator.this.getModule((EObject)annotation);
                Project _project = module.getProject();
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)_project);
                PsiClass _findClass = psiFacade.findClass(_qualifiedName = annotationType.getQualifiedName(), _moduleScope = module.getModuleScope());
                return !Objects.equal((Object)_findClass, null);
            }
        };
        return (Boolean)_application.runReadAction((Computable)_function);
    }

    protected Module getModule(EObject object) {
        Resource _eResource = object.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        return ModuleProvider.findModule((ResourceSet)_resourceSet);
    }

    @Check
    public void checkFileNameConventions(XtendFile xtendFile) {
        String expectedPackage = this.getExpectedPackageName(xtendFile);
        boolean _equals = Objects.equal((Object)expectedPackage, null);
        if (_equals) {
            return;
        }
        String declaredPackage = xtendFile.getPackage();
        if (expectedPackage.isEmpty() && Objects.equal((Object)declaredPackage, null)) {
            return;
        }
        boolean _equals_1 = Objects.equal((Object)expectedPackage, (Object)declaredPackage);
        if (_equals_1) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"The declared package '");
        String _notNull = Strings.notNull((Object)declaredPackage);
        _builder.append((Object)_notNull, "");
        _builder.append((Object)"' does not match the expected package '");
        String _notNull_1 = Strings.notNull((Object)expectedPackage);
        _builder.append((Object)_notNull_1, "");
        _builder.append((Object)"'");
        this.error(_builder.toString(), (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, -1, "org.eclipse.xtend.core.validation.IssueCodes.wrong_package", new String[]{expectedPackage});
    }

    protected String getExpectedPackageName(final XtendFile xtendFile) {
        Application _application = ApplicationManager.getApplication();
        Computable<String> _function = new Computable<String>(){

            public String compute() {
                Resource _eResource = xtendFile.eResource();
                URI _uRI = _eResource.getURI();
                VirtualFile file = VirtualFileURIUtil.getVirtualFile((URI)_uRI);
                Module _module = XtendIdeaValidator.this.getModule((EObject)xtendFile);
                Project _project = _module.getProject();
                PsiManager _instance = PsiManager.getInstance((Project)_project);
                VirtualFile _parent = file.getParent();
                PsiDirectory psiDirectory = _instance.findDirectory(_parent);
                JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
                PsiPackage _package = javaDirectoryService.getPackage(psiDirectory);
                return _package.getQualifiedName();
            }
        };
        return (String)_application.runReadAction((Computable)_function);
    }
}

