/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.documentation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.idea.documentation.IdeaDeclarationDocumentationProvider;
import org.eclipse.xtext.idea.trace.ITraceForVirtualFileProvider;
import org.eclipse.xtext.psi.PsiEObject;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class IdeaDocumentationProvider
extends AbstractDocumentationProvider {
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private ITraceForVirtualFileProvider traceProvider;

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        boolean _notEquals;
        GeneratedCodeDelegate gen = this.findDocumentationInGeneratedCode(element, originalElement);
        boolean bl = _notEquals = !Objects.equal((Object)gen, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String result = gen.delegate.getQuickNavigateInfo(gen.generatedElement, gen.generatedOriginalElement);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)result, null);
            if (_notEquals_1) {
                return result;
            }
        }
        if (element instanceof PsiEObject) {
            String result_1;
            boolean _notEquals_2;
            EObject eobj = ((PsiEObject)element).getEObject();
            IdeaDeclarationDocumentationProvider _calleeDocumentationProvider = this.getCalleeDocumentationProvider(eobj);
            String _quickNavigateInfo = null;
            if (_calleeDocumentationProvider != null) {
                _quickNavigateInfo = _calleeDocumentationProvider.getQuickNavigateInfo((PsiEObject)element);
            }
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)(result_1 = _quickNavigateInfo), null);
            if (_notEquals_2) {
                return result_1;
            }
            URI _uRI = EcoreUtil.getURI((EObject)eobj);
            return _uRI.toString();
        }
        return null;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        boolean _notEquals;
        GeneratedCodeDelegate gen = this.findDocumentationInGeneratedCode(element, originalElement);
        boolean bl = _notEquals = !Objects.equal((Object)gen, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String result = gen.delegate.generateDoc(gen.generatedElement, gen.generatedOriginalElement);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)result, null);
            if (_notEquals_1) {
                return result;
            }
        }
        if (element instanceof PsiEObject) {
            String result_1;
            boolean _notEquals_2;
            EObject eobj = ((PsiEObject)element).getEObject();
            IdeaDeclarationDocumentationProvider _calleeDocumentationProvider = this.getCalleeDocumentationProvider(eobj);
            String _generateDoc = null;
            if (_calleeDocumentationProvider != null) {
                _generateDoc = _calleeDocumentationProvider.generateDoc((PsiEObject)element);
            }
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)(result_1 = _generateDoc), null);
            if (_notEquals_2) {
                return result_1;
            }
            URI _uRI = EcoreUtil.getURI((EObject)eobj);
            return _uRI.toString();
        }
        return null;
    }

    protected IdeaDeclarationDocumentationProvider getCalleeDocumentationProvider(EObject object) {
        boolean _eIsProxy;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)object, null);
        _or = _equals ? true : (_eIsProxy = object.eIsProxy());
        if (_or) {
            return null;
        }
        Resource _eResource = object.eResource();
        URI uri = _eResource.getURI();
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri);
        boolean _equals_1 = Objects.equal((Object)resourceServiceProvider, null);
        if (_equals_1) {
            return null;
        }
        IdeaDeclarationDocumentationProvider _get = null;
        if (resourceServiceProvider != null) {
            _get = (IdeaDeclarationDocumentationProvider)resourceServiceProvider.get(IdeaDeclarationDocumentationProvider.class);
        }
        return _get;
    }

    protected GeneratedCodeDelegate findDocumentationInGeneratedCode(PsiElement element, PsiElement originalElement) {
        PsiElement generatedElement = this.getGeneratedElement(element);
        boolean _equals = Objects.equal((Object)generatedElement, null);
        if (_equals) {
            return null;
        }
        PsiElement _elvis = null;
        PsiElement _generatedElement = this.getGeneratedElement(originalElement);
        _elvis = _generatedElement != null ? _generatedElement : originalElement;
        PsiElement generatedOriginalElement = _elvis;
        DocumentationProvider delegate = DocumentationManager.getProviderFromElement((PsiElement)generatedElement, (PsiElement)generatedOriginalElement);
        boolean _equals_1 = Objects.equal((Object)delegate, null);
        if (_equals_1) {
            return null;
        }
        return new GeneratedCodeDelegate(generatedElement, generatedOriginalElement, delegate);
    }

    private PsiElement getGeneratedElement(PsiElement element) {
        List<? extends PsiElement> elements = this.traceProvider.getGeneratedElements(element);
        PsiElement result = (PsiElement)IterableExtensions.head(elements);
        if (result instanceof PsiIdentifier) {
            return ((PsiIdentifier)result).getParent();
        }
        return result;
    }

    @Accessors
    public static class GeneratedCodeDelegate {
        private final PsiElement generatedElement;
        private final PsiElement generatedOriginalElement;
        private final DocumentationProvider delegate;

        public GeneratedCodeDelegate(PsiElement generatedElement, PsiElement generatedOriginalElement, DocumentationProvider delegate) {
            this.generatedElement = generatedElement;
            this.generatedOriginalElement = generatedOriginalElement;
            this.delegate = delegate;
        }

        @Pure
        public PsiElement getGeneratedElement() {
            return this.generatedElement;
        }

        @Pure
        public PsiElement getGeneratedOriginalElement() {
            return this.generatedOriginalElement;
        }

        @Pure
        public DocumentationProvider getDelegate() {
            return this.delegate;
        }
    }
}

