/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.IGrammarPDAProvider;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializerPDA;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaUtil;

@Singleton
public class ContextPDAProvider
implements IContextPDAProvider {
    private static Logger LOG = Logger.getLogger(ContextPDAProvider.class);
    @Inject
    protected SerializerPDA.SerializerPDAElementFactory factory;
    @Inject
    private IGrammarPDAProvider grammarPdaProvider;
    @Inject
    private NfaUtil nfaUtil;
    @Inject
    protected PdaUtil pdaUtil;

    /*
     * Enabled aggressive block sorting
     */
    protected void collectExtracted(ISerState orig, Collection<? extends ISerState> precedents, SerializerPDA.SerializerPDAState copy, Map<Pair<AbstractElement, ISerState.SerStateType>, SerializerPDA.SerializerPDAState> oldToNew, CallStack inTop, SerializerPDA.SerializerPDAState start) {
        block5: for (ISerState iSerState : precedents) {
            CallStack top = inTop;
            AbstractElement element = iSerState.getGrammarElement();
            switch (iSerState.getType()) {
                case START: {
                    if (top.call != null) continue block5;
                    this.connect(start, copy);
                    continue block5;
                }
                case POP: {
                    top = new CallStack(top, (RuleCall)element);
                    if (!top.isLoop()) break;
                    continue block5;
                }
                case PUSH: {
                    if (top.call == null) {
                        this.connect(start, copy);
                        continue block5;
                    }
                    if (top.call != element) continue block5;
                    top = top.parent;
                }
            }
            Pair key = Tuples.create((Object)element, (Object)((Object)iSerState.getType()));
            SerializerPDA.SerializerPDAState pre2 = oldToNew.get(key);
            if (pre2 == null) {
                pre2 = new SerializerPDA.SerializerPDAState(element, iSerState.getType());
                oldToNew.put((Pair<AbstractElement, ISerState.SerStateType>)key, pre2);
            }
            if (GrammarUtil.isAssignedAction(iSerState.getGrammarElement())) {
                Set<ISerState> entries = this.collectPushForAction(iSerState);
                this.collectExtracted(iSerState, entries, pre2, oldToNew, top, start);
            } else if (top.visited.add(iSerState)) {
                this.collectExtracted(iSerState, iSerState.getPrecedents(), pre2, oldToNew, top, start);
            }
            this.connect(pre2, copy);
        }
    }

    protected Set<ISerState> collectPushForAction(ISerState action) {
        ParserRule rule = GrammarUtil.containingParserRule(action.getGrammarElement());
        LinkedHashSet result = Sets.newLinkedHashSet();
        this.collectPushForAction(action, rule, result, Sets.newHashSet());
        return result;
    }

    protected void collectPushForAction(ISerState state, ParserRule rule, Set<ISerState> result, Set<ISerState> visited) {
        if (!visited.add(state)) {
            return;
        }
        switch (state.getType()) {
            case START: {
                result.add(state);
                return;
            }
            case PUSH: {
                AbstractElement element = state.getGrammarElement();
                if (!(element instanceof RuleCall) || ((RuleCall)element).getRule() != rule) break;
                result.add(state);
                return;
            }
        }
        List<? extends ISerState> precedents = state.getPrecedents();
        for (ISerState iSerState : precedents) {
            this.collectPushForAction(iSerState, rule, result, visited);
        }
    }

    protected void connect(SerializerPDA.SerializerPDAState precedent, SerializerPDA.SerializerPDAState follower) {
        if (precedent == null || follower == null) {
            return;
        }
        if (follower.getPrecedents().contains(precedent)) {
            return;
        }
        follower.getPrecedents().add(precedent);
        precedent.getFollowers().add(follower);
    }

    protected SerializerPDA extract(ISerState last) {
        SerializerPDA result = this.factory.create(null, null);
        HashMap oldToNew = Maps.newHashMap();
        CallStack callStack = new CallStack(null, null);
        this.collectExtracted(last, last.getPrecedents(), result.getStop(), oldToNew, callStack, result.getStart());
        return result;
    }

    protected EObject getContext(AbstractElement ele) {
        if (ele instanceof RuleCall) {
            if (GrammarUtil.isAssignedEObjectRuleCall(ele)) {
                return ((RuleCall)ele).getRule();
            }
        } else if (GrammarUtil.isAssignedAction(ele)) {
            return ele;
        }
        return null;
    }

    @Override
    public Map<ISerializationContext, Pda<ISerState, RuleCall>> getContextPDAs(Grammar grammar) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Map<ISerializationContext, Pda<ISerState, RuleCall>> grammarPDAs = this.grammarPdaProvider.getGrammarPDAs(grammar);
        HashMultimap actionPdas = HashMultimap.create();
        HashMultimap actionContexts = HashMultimap.create();
        for (Map.Entry<ISerializationContext, Pda<ISerState, RuleCall>> entry : grammarPDAs.entrySet()) {
            ISerializationContext context = entry.getKey();
            Pda<ISerState, RuleCall> pda = entry.getValue();
            ArrayList actions = Lists.newArrayList();
            for (ISerState state : this.nfaUtil.collect(pda)) {
                if (!GrammarUtil.isAssignedAction(state.getGrammarElement())) continue;
                actions.add(state);
            }
            if (actions.isEmpty()) {
                result.put(context, pda);
                continue;
            }
            try {
                SerializerPDA rulePda = this.extract((ISerState)pda.getStop());
                result.put(context, rulePda);
                for (ISerState state : actions) {
                    Action action = (Action)state.getGrammarElement();
                    SerializerPDA actionPda = this.extract(state);
                    actionPdas.put((Object)action, (Object)actionPda);
                    actionContexts.put((Object)action, (Object)context);
                }
            }
            catch (Exception x) {
                LOG.error((Object)("Error extracting PDA for action in context '" + context + "': " + x.getMessage()), (Throwable)x);
            }
        }
        for (Map.Entry<ISerializationContext, Object> entry : actionPdas.asMap().entrySet()) {
            SerializerPDA merged = this.merge(new SerializationContext.ActionContext(null, (Action)((Object)entry.getKey())), (Collection)entry.getValue());
            LinkedHashSet parameterPermutations = Sets.newLinkedHashSet();
            for (ISerializationContext container : actionContexts.get((Object)((Action)((Object)entry.getKey())))) {
                parameterPermutations.add(container.getEnabledBooleanParameters());
            }
            for (Set parameters : parameterPermutations) {
                SerializationContext context = new SerializationContext.ActionContext(null, (Action)((Object)entry.getKey()));
                if (!parameters.isEmpty()) {
                    context = new SerializationContext.ParameterValueContext(context, parameters);
                }
                result.put(context, merged);
            }
        }
        return result;
    }

    protected SerializerPDA merge(ISerializationContext context, Collection<SerializerPDA> pdas) {
        if (pdas.isEmpty()) {
            throw new IllegalStateException();
        }
        if (pdas.size() == 1) {
            return pdas.iterator().next();
        }
        SerializerPDA merged = this.factory.create(null, null);
        HashMap oldToNew = Maps.newHashMap();
        for (Pda pda : pdas) {
            oldToNew.put((ISerState)pda.getStop(), merged.getStop());
            this.merge((ISerState)pda.getStart(), merged.getStart(), oldToNew, new IdentityHashMap<ISerState, Boolean>());
        }
        return merged;
    }

    protected void merge(ISerState orig, SerializerPDA.SerializerPDAState copy, Map<ISerState, SerializerPDA.SerializerPDAState> oldToNew, IdentityHashMap<ISerState, Boolean> visited) {
        for (ISerState iSerState : orig.getFollowers()) {
            SerializerPDA.SerializerPDAState folCopy = oldToNew.get(iSerState);
            if (folCopy == null) {
                folCopy = new SerializerPDA.SerializerPDAState(iSerState.getGrammarElement(), iSerState.getType());
                oldToNew.put(iSerState, folCopy);
            }
            this.connect(copy, folCopy);
            if (visited.put(iSerState, Boolean.TRUE) != null) continue;
            this.merge(iSerState, folCopy, oldToNew, visited);
        }
    }

    protected static class CallStack {
        private final RuleCall call;
        private final CallStack parent;
        private final Set<ISerState> visited = Sets.newHashSet();

        public CallStack(CallStack parent, RuleCall call) {
            this.parent = parent;
            this.call = call;
        }

        public boolean isLoop() {
            CallStack current = this.parent;
            int counter = 0;
            while (current != null) {
                if (current.call == this.call) {
                    ++counter;
                }
                if (counter >= 2) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }
    }
}

