/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.idea.imports;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.imports.ImportOrganizer;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XImportSectionOptimizer
implements ImportOptimizer {
    @Inject
    @Named(value="languageName")
    private String languageId;
    @Inject
    private ImportOrganizer importOrganizer;

    public Runnable processFile(final PsiFile file) {
        if (file instanceof BaseXtextFile) {
            XtextResource _resource = ((BaseXtextFile)file).getResource();
            List _organizedImportChanges = this.importOrganizer.getOrganizedImportChanges(_resource);
            Functions.Function1<ReplaceRegion, Integer> _function = new Functions.Function1<ReplaceRegion, Integer>(){

                public Integer apply(ReplaceRegion it) {
                    int _offset = it.getOffset();
                    return _offset * -1;
                }
            };
            final List changes = IterableExtensions.sortBy((Iterable)_organizedImportChanges, (Functions.Function1)_function);
            Runnable _function_1 = new Runnable(){

                @Override
                public void run() {
                    Project _project = ((BaseXtextFile)file).getProject();
                    PsiDocumentManager _instance = PsiDocumentManager.getInstance((Project)_project);
                    Document document = _instance.getDocument(file);
                    for (ReplaceRegion change : changes) {
                        int _offset = change.getOffset();
                        int _endOffset = change.getEndOffset();
                        String _text = change.getText();
                        document.replaceString(_offset, _endOffset, (CharSequence)_text);
                    }
                }
            };
            return _function_1;
        }
        return EmptyRunnable.INSTANCE;
    }

    public boolean supports(PsiFile file) {
        Language _language = file.getLanguage();
        String _iD = _language.getID();
        return Objects.equal((Object)this.languageId, (Object)_iD);
    }
}

