/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class RootModelExtensions {
    public static Iterable<SourceFolder> getSourceFolders(Module module) {
        ModuleRootManager _instance = ModuleRootManager.getInstance((Module)module);
        ContentEntry[] _contentEntries = _instance.getContentEntries();
        Functions.Function1<ContentEntry, List<SourceFolder>> _function = new Functions.Function1<ContentEntry, List<SourceFolder>>(){

            public List<SourceFolder> apply(ContentEntry it) {
                SourceFolder[] _sourceFolders = it.getSourceFolders();
                return IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)_sourceFolders)));
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_contentEntries)), (Functions.Function1)_function);
        return Iterables.concat((Iterable)_map);
    }

    public static Iterable<SourceFolder> getExistingSourceFolders(Module module) {
        Iterable<SourceFolder> _sourceFolders = RootModelExtensions.getSourceFolders(module);
        Functions.Function1<SourceFolder, Boolean> _function = new Functions.Function1<SourceFolder, Boolean>(){

            public Boolean apply(SourceFolder it) {
                VirtualFile _file = it.getFile();
                return !Objects.equal((Object)_file, null);
            }
        };
        return IterableExtensions.filter(_sourceFolders, (Functions.Function1)_function);
    }

    public static String getRelativePath(SourceFolder sourceFolder) {
        VirtualFile _file = sourceFolder.getFile();
        ContentEntry _contentEntry = sourceFolder.getContentEntry();
        VirtualFile _file_1 = _contentEntry.getFile();
        return VfsUtil.getRelativePath((VirtualFile)_file, (VirtualFile)_file_1);
    }
}

