/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.filesystem;

import com.google.common.base.Objects;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.idea.filesystem.IdeaProjectConfig;
import org.eclipse.xtext.idea.resource.VirtualFileURIUtil;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
@Log
public class IdeaWorkspaceConfig
implements IWorkspaceConfig {
    private final Project project;
    private static final Logger LOG = Logger.getLogger(IdeaWorkspaceConfig.class);

    public Set<? extends IProjectConfig> getProjects() {
        Application _application = ApplicationManager.getApplication();
        Computable<Module[]> _function = new Computable<Module[]>(){

            public Module[] compute() {
                ModuleManager _instance = ModuleManager.getInstance((Project)IdeaWorkspaceConfig.this.project);
                return _instance.getModules();
            }
        };
        Module[] modules = (Module[])_application.runReadAction((Computable)_function);
        Functions.Function1<Module, IdeaProjectConfig> _function_1 = new Functions.Function1<Module, IdeaProjectConfig>(){

            public IdeaProjectConfig apply(Module it) {
                return IdeaWorkspaceConfig.this.toIdeaProjectConfig(it);
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)modules)), (Functions.Function1)_function_1);
        return IterableExtensions.toSet((Iterable)_map);
    }

    public IdeaProjectConfig findProjectByName(final String name) {
        Computable<Module> _function;
        Application _application = ApplicationManager.getApplication();
        Module module = (Module)_application.runReadAction((Computable)(_function = new Computable<Module>(){

            public Module compute() {
                ModuleManager _instance = ModuleManager.getInstance((Project)IdeaWorkspaceConfig.this.project);
                return _instance.findModuleByName(name);
            }
        }));
        if (module != null) {
            return this.toIdeaProjectConfig(module);
        }
        return null;
    }

    private IdeaProjectConfig toIdeaProjectConfig(Module module) {
        return new IdeaProjectConfig(module);
    }

    public IdeaProjectConfig findProjectContaining(URI member) {
        boolean _notEquals;
        VirtualFile file = VirtualFileURIUtil.getVirtualFile(member);
        if (file == null) {
            return null;
        }
        ProjectRootManager _instance = ProjectRootManager.getInstance((Project)this.project);
        ProjectFileIndex fileIndex = _instance.getFileIndex();
        Module module = fileIndex.getModuleForFile(file, true);
        if (module == null) {
            return null;
        }
        VirtualFile contentRoot = fileIndex.getContentRootForFile(file, true);
        if (contentRoot == null) {
            return null;
        }
        IdeaProjectConfig result = new IdeaProjectConfig(module);
        VirtualFile _contentRoot = result.getContentRoot();
        boolean bl = _notEquals = !Objects.equal((Object)contentRoot, (Object)_contentRoot);
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"The file (");
            _builder.append((Object)member, "");
            _builder.append((Object)") should belong to the first content root (");
            VirtualFile _contentRoot_1 = result.getContentRoot();
            _builder.append((Object)_contentRoot_1, "");
            _builder.append((Object)") but belongs to ");
            _builder.append((Object)contentRoot, "");
            _builder.append((Object)".");
            LOG.error((Object)_builder);
        }
        return result;
    }

    public IdeaWorkspaceConfig(Project project) {
        this.project = project;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdeaWorkspaceConfig other = (IdeaWorkspaceConfig)obj;
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("project", (Object)this.project);
        return b.toString();
    }

    @Pure
    public Project getProject() {
        return this.project;
    }
}

