/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.lang.parser;

import com.google.inject.Singleton;
import com.intellij.lang.Language;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.eclipse.xtext.idea.lang.XtextLanguage;
import org.eclipse.xtext.idea.parser.TokenTypeProvider;
import org.eclipse.xtext.idea.parser.antlr.internal.PsiInternalXtextParser;

@Singleton
public class XtextTokenTypeProvider
implements TokenTypeProvider {
    private static final String[] TOKEN_NAMES = new PsiInternalXtextParser(null).getTokenNames();
    private static final IElementType[] tokenTypes = new IElementType[TOKEN_NAMES.length];
    private static final TokenSet WHITESPACE_TOKENS;
    private static final TokenSet COMMENT_TOKENS;
    private static final TokenSet STRING_TOKENS;

    public int getAntlrType(IElementType iElementType) {
        return iElementType instanceof TokenTypeProvider.IndexedElementType ? ((TokenTypeProvider.IndexedElementType)iElementType).getLocalIndex() : 0;
    }

    public IElementType getIElementType(int antlrType) {
        return tokenTypes[antlrType];
    }

    public TokenSet getWhitespaceTokens() {
        return WHITESPACE_TOKENS;
    }

    public TokenSet getCommentTokens() {
        return COMMENT_TOKENS;
    }

    public TokenSet getStringLiteralTokens() {
        return STRING_TOKENS;
    }

    static {
        for (int i = 0; i < TOKEN_NAMES.length; ++i) {
            XtextTokenTypeProvider.tokenTypes[i] = new TokenTypeProvider.IndexedElementType(TOKEN_NAMES[i], i, (Language)XtextLanguage.INSTANCE);
        }
        WHITESPACE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{tokenTypes[9]});
        COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{tokenTypes[8], tokenTypes[7]});
        STRING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{tokenTypes[4]});
    }
}

