/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.epp.internal.mpc.ui.commands.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.ComboTagFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizardDialog;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.mpc.core.model.ICatalog;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.service.ICatalogService;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogFilter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceWizardCommand
extends AbstractHandler
implements IHandler {
    private List<CatalogDescriptor> catalogDescriptors;
    private CatalogDescriptor selectedCatalogDescriptor;
    private String wizardState;
    private Map<String, org.eclipse.epp.mpc.ui.Operation> operations;
    private MarketplaceWizard.WizardState wizardDialogState;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final MarketplaceCatalog catalog = new MarketplaceCatalog();
        catalog.setEnvironment(DiscoveryCore.createEnvironment());
        catalog.setVerifyUpdateSiteAvailability(false);
        MarketplaceCatalogConfiguration configuration = new MarketplaceCatalogConfiguration();
        configuration.setVerifyUpdateSiteAvailability(false);
        if (this.catalogDescriptors == null || this.catalogDescriptors.isEmpty()) {
            IStatus remoteCatalogStatus = this.installRemoteCatalogs();
            configuration.getCatalogDescriptors().addAll(CatalogRegistry.getInstance().getCatalogDescriptors());
            if (configuration.getCatalogDescriptors().isEmpty()) {
                Object cause = !remoteCatalogStatus.isOK() ? remoteCatalogStatus : new Status(4, "org.eclipse.epp.mpc.ui", Messages.MarketplaceWizardCommand_noRemoteCatalogs);
                Status exitStatus = new Status(4, "org.eclipse.epp.mpc.ui", cause.getCode(), Messages.MarketplaceWizardCommand_cannotOpenMarketplace, (Throwable)new CoreException(cause));
                try {
                    MarketplaceClientUi.handle((IStatus)exitStatus, 6 | (exitStatus.getSeverity() == 8 ? 0 : 1));
                }
                catch (Exception exception) {
                    MarketplaceClientUi.getLog().log((IStatus)exitStatus);
                }
                return null;
            }
            if (!remoteCatalogStatus.isOK()) {
                MarketplaceClientUi.handle(remoteCatalogStatus, 1);
            }
        } else {
            configuration.getCatalogDescriptors().addAll(this.catalogDescriptors);
        }
        if (this.selectedCatalogDescriptor != null) {
            if (this.selectedCatalogDescriptor.getLabel().equals("org.eclipse.epp.mpc.descriptorHint")) {
                CatalogDescriptor resolvedDescriptor = CatalogRegistry.getInstance().findCatalogDescriptor(this.selectedCatalogDescriptor.getUrl().toExternalForm());
                if (resolvedDescriptor == null) {
                    Status status = new Status(4, "org.eclipse.epp.mpc.ui", Messages.MarketplaceWizardCommand_CouldNotFindMarketplaceForSolution, (Throwable)new ExecutionException(this.selectedCatalogDescriptor.getUrl().toExternalForm()));
                    MarketplaceClientUi.handle((IStatus)status, 7);
                    return null;
                }
                configuration.setCatalogDescriptor(resolvedDescriptor);
            } else {
                configuration.setCatalogDescriptor(this.selectedCatalogDescriptor);
            }
        }
        configuration.getFilters().clear();
        final ComboTagFilter marketFilter = new ComboTagFilter(){

            public void catalogUpdated(boolean wasCancelled) {
                ArrayList<Tag> choices = new ArrayList<Tag>();
                List<IMarket> markets = catalog.getMarkets();
                for (IMarket market : markets) {
                    Tag marketTag = new Tag(IMarket.class, market.getId(), market.getName());
                    marketTag.setData((Object)market);
                    choices.add(marketTag);
                }
                this.setChoices(choices);
            }
        };
        marketFilter.setSelectAllOnNoSelection(true);
        marketFilter.setNoSelectionLabel(Messages.MarketplaceWizardCommand_allMarkets);
        marketFilter.setTagClassification(ICategory.class);
        marketFilter.setChoices(new ArrayList<Tag>());
        final ComboTagFilter marketCategoryTagFilter = new ComboTagFilter(){

            public void catalogUpdated(boolean wasCancelled) {
                MarketplaceWizardCommand.this.updateCategoryChoices(this, marketFilter);
            }
        };
        marketCategoryTagFilter.setSelectAllOnNoSelection(true);
        marketCategoryTagFilter.setNoSelectionLabel(Messages.MarketplaceWizardCommand_allCategories);
        marketCategoryTagFilter.setTagClassification(ICategory.class);
        marketCategoryTagFilter.setChoices(new ArrayList<Tag>());
        IPropertyChangeListener marketListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("selected".equals(property)) {
                    MarketplaceWizardCommand.this.updateCategoryChoices(marketCategoryTagFilter, marketFilter);
                }
            }
        };
        marketFilter.addPropertyChangeListener(marketListener);
        configuration.getFilters().add(marketFilter);
        configuration.getFilters().add(marketCategoryTagFilter);
        configuration.setInitialState(this.wizardState);
        if (this.operations != null && !this.operations.isEmpty()) {
            configuration.setInitialOperations(this.operations);
        }
        for (CatalogFilter filter : configuration.getFilters()) {
            ((MarketplaceFilter)filter).setCatalog(catalog);
        }
        MarketplaceWizard wizard = new MarketplaceWizard(catalog, configuration);
        wizard.setInitialState(this.wizardDialogState);
        wizard.setWindowTitle(Messages.MarketplaceWizardCommand_eclipseMarketplace);
        MarketplaceWizardDialog dialog = new MarketplaceWizardDialog(WorkbenchUtil.getShell(), wizard);
        dialog.open();
        return null;
    }

    private void updateCategoryChoices(ComboTagFilter marketCategoryTagFilter, ComboTagFilter marketFilter) {
        HashSet<Tag> newChoices = new HashSet<Tag>();
        ArrayList<Tag> choices = new ArrayList<Tag>();
        HashSet<IMarket> selectedMarkets = new HashSet<IMarket>();
        for (Tag marketTag : marketFilter.getSelected()) {
            selectedMarkets.add((IMarket)marketTag.getData());
        }
        MarketplaceCatalog catalog = (MarketplaceCatalog)marketCategoryTagFilter.getCatalog();
        List<IMarket> markets = catalog.getMarkets();
        for (IMarket market : markets) {
            if (!selectedMarkets.isEmpty() && !selectedMarkets.contains(market)) continue;
            for (ICategory marketCategory : market.getCategory()) {
                Tag categoryTag = new Tag(ICategory.class, marketCategory.getId(), marketCategory.getName());
                categoryTag.setData((Object)marketCategory);
                if (!newChoices.add(categoryTag)) continue;
                choices.add(categoryTag);
            }
        }
        Collections.sort(choices, new Comparator<Tag>(){

            @Override
            public int compare(Tag o1, Tag o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        marketCategoryTagFilter.setChoices(choices);
    }

    public void setCatalogDescriptors(List<CatalogDescriptor> catalogDescriptors) {
        this.catalogDescriptors = catalogDescriptors;
    }

    public void setSelectedCatalogDescriptor(CatalogDescriptor selectedCatalogDescriptor) {
        this.selectedCatalogDescriptor = selectedCatalogDescriptor;
    }

    public void setWizardState(String wizardState) {
        this.wizardState = wizardState;
    }

    public void setWizardDialogState(MarketplaceWizard.WizardState wizardState) {
        this.wizardDialogState = wizardState;
    }

    @Deprecated
    public void setOperationByNodeId(Map<String, Operation> operationByNodeId) {
        this.operations = Operation.mapAllBack(operationByNodeId);
    }

    public void setOperations(Map<String, org.eclipse.epp.mpc.ui.Operation> operationByNodeId) {
        this.operations = operationByNodeId;
    }

    public void setConfiguration(IMarketplaceClientConfiguration configuration) {
        this.setCatalogDescriptors(configuration.getCatalogDescriptors());
        this.setOperations(configuration.getInitialOperations());
        this.setWizardState((String)configuration.getInitialState());
        this.setSelectedCatalogDescriptor(configuration.getCatalogDescriptor());
    }

    public IStatus installRemoteCatalogs() {
        try {
            final AtomicReference result = new AtomicReference();
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ICatalogService catalogService = ServiceHelper.getMarketplaceServiceLocator().getCatalogService();
                        List catalogs = catalogService.listCatalogs(monitor);
                        result.set(catalogs);
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getSeverity() == 8) {
                            throw new InterruptedException();
                        }
                        throw new InvocationTargetException(e);
                    }
                }
            });
            List catalogs = (List)result.get();
            for (ICatalog catalog : catalogs) {
                ResourceProvider resourceProvider = MarketplaceClientUiPlugin.getInstance().getResourceProvider();
                String catalogName = catalog.getName();
                String requestSource = NLS.bind((String)Messages.MarketplaceWizardCommand_requestCatalog, (Object)catalogName, (Object)catalog.getId());
                String catalogImageUrl = catalog.getImageUrl();
                if (catalogImageUrl != null) {
                    try {
                        resourceProvider.retrieveResource(requestSource, catalogImageUrl);
                    }
                    catch (Exception e) {
                        MarketplaceClientUi.log(2, Messages.MarketplaceWizardCommand_FailedRetrievingCatalogImage, catalogName, catalogImageUrl, e);
                    }
                }
                if (catalog.getBranding() != null && catalog.getBranding().getWizardIcon() != null) {
                    String wizardIconUrl = catalog.getBranding().getWizardIcon();
                    try {
                        resourceProvider.retrieveResource(requestSource, wizardIconUrl);
                    }
                    catch (Exception e) {
                        MarketplaceClientUi.log(2, Messages.MarketplaceWizardCommand_FailedRetrievingCatalogWizardIcon, catalogName, wizardIconUrl, e);
                    }
                }
                CatalogDescriptor descriptor = new CatalogDescriptor(catalog);
                this.registerOrOverrideCatalog(descriptor);
            }
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            IStatus status = MarketplaceClientCore.computeStatus((Throwable)e, (String)Messages.MarketplaceWizardCommand_CannotInstallRemoteLocations);
            return status;
        }
        return Status.OK_STATUS;
    }

    private void registerOrOverrideCatalog(CatalogDescriptor descriptor) {
        CatalogRegistry catalogRegistry = CatalogRegistry.getInstance();
        List<CatalogDescriptor> descriptors = catalogRegistry.getCatalogDescriptors();
        for (CatalogDescriptor catalogDescriptor : descriptors) {
            if (!catalogDescriptor.getUrl().toExternalForm().equals(descriptor.getUrl().toExternalForm())) continue;
            catalogRegistry.unregister(catalogDescriptor);
        }
        catalogRegistry.register(descriptor);
    }
}

