/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.editors.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.commons.ui.TableSorter;
import org.eclipse.mylyn.internal.reviews.ui.ReviewColumnLabelProvider;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsUiPlugin;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.Messages;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.TaskReview;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.reviews.internal.core.TaskReviewsMappingsStore;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorReviewsPart
extends AbstractTaskEditorPart {
    private static final String ID_TASK_EDITOR_REVIEWS_PART = "org.eclipse.mylyn.internal.reviews.ui.editor.parts.TaskEditorReviewsPart";
    private Composite reviewsComposite;
    protected Section section;
    private Table reviewsTable;
    private final String[] REVIEWS_COLUMNS = new String[]{Messages.TaskEditorReviewsPart_DescriptionString, Messages.TaskEditorReviewsPart_CodeReviewString, Messages.TaskEditorReviewsPart_VerifiedString, "Status"};
    private SelectionProviderAdapter selectionProvider;
    private final int[] REVIEWS_COLUMNS_WIDTH;
    private TableViewer reviewsViewer;
    private List<TaskReview> reviewContainers;
    private Collection<ITask> reviews;
    private final TaskReviewsMappingsStore taskReviewStore;
    private final TaskList taskList;

    public TaskEditorReviewsPart() {
        int[] nArray = new int[5];
        nArray[0] = 575;
        nArray[1] = 30;
        nArray[2] = 30;
        nArray[3] = 90;
        this.REVIEWS_COLUMNS_WIDTH = nArray;
        this.taskList = TasksUiPlugin.getTaskList();
        this.taskReviewStore = ReviewsUiPlugin.getDefault().getTaskReviewsMappingStore();
        this.setPartName(Messages.TaskEditorReviewsPart_ReviewsString);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.taskReviewStore != null) {
            Collection reviewUrls = this.taskReviewStore.getReviewUrls(this.getTaskEditorPage().getTask().getUrl());
            this.getReviewsFromUrls(reviewUrls);
        }
        if (this.reviews == null || this.reviews.size() == 0) {
            return;
        }
        this.reviewContainers = new ArrayList<TaskReview>();
        this.populateReviews(this.reviewContainers);
        this.selectionProvider = new SelectionProviderAdapter();
        this.section = this.createSection(parent, toolkit, true);
        this.section.setText(this.section.getText());
        this.createContents(toolkit, this.section);
        this.setSection(toolkit, this.section);
    }

    private void getReviewsFromUrls(Collection<String> reviewUrls) {
        this.reviews = new ArrayList<ITask>();
        for (String reviewUrl : reviewUrls) {
            ITask review;
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(reviewUrl);
            if (connector == null) continue;
            String repositoryUrl = connector.getRepositoryUrlFromTaskUrl(reviewUrl);
            String reviewId = connector.getTaskIdFromTaskUrl(reviewUrl);
            if (repositoryUrl == null || reviewId == null || (review = this.taskList.getTask(repositoryUrl, reviewId)) == null) continue;
            this.reviews.add(review);
        }
    }

    private void createReviewsTable(FormToolkit toolkit, Composite composite) {
        this.reviewsTable = toolkit.createTable(this.reviewsComposite, 65538);
        this.reviewsTable.setLinesVisible(true);
        this.reviewsTable.setHeaderVisible(true);
        this.reviewsTable.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(500, -1).applyTo((Control)this.reviewsTable);
        this.reviewsTable.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.reviewsViewer = new TableViewer(this.reviewsTable);
        int i = 0;
        while (i < this.REVIEWS_COLUMNS.length) {
            final TableColumn column = new TableColumn(this.reviewsTable, 16384, i);
            column.setText(this.REVIEWS_COLUMNS[i]);
            column.setWidth(this.REVIEWS_COLUMNS_WIDTH[i]);
            column.setMoveable(true);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int direction = TaskEditorReviewsPart.this.reviewsTable.getSortDirection();
                    direction = TaskEditorReviewsPart.this.reviewsTable.getSortColumn() == column && direction != 0 ? (direction == 1024 ? 128 : 0) : 1024;
                    TaskEditorReviewsPart.this.reviewsTable.setSortDirection(direction);
                    if (direction == 0) {
                        TaskEditorReviewsPart.this.reviewsTable.setSortColumn(null);
                    } else {
                        TaskEditorReviewsPart.this.reviewsTable.setSortColumn(column);
                    }
                    TaskEditorReviewsPart.this.reviewsViewer.refresh();
                }
            });
            ++i;
        }
        this.reviewsViewer.setUseHashlookup(true);
        this.reviewsViewer.setColumnProperties(this.REVIEWS_COLUMNS);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.reviewsViewer, (int)2);
        this.reviewsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ReviewColumnLabelProvider labelProvider = new ReviewColumnLabelProvider();
        this.reviewsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.reviewsViewer.setComparator((ViewerComparator)new ReviewColumnSorter(labelProvider));
        this.reviewsViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TaskEditorReviewsPart.this.openReview(event);
            }
        });
        this.reviewsViewer.setInput((Object)this.reviewContainers.toArray());
        this.getTaskEditorPage().reflow();
    }

    private void populateReviews(List<TaskReview> reviewContainers) {
        for (ITask review : this.reviews) {
            reviewContainers.add(new TaskReview(review));
        }
    }

    private void createContents(FormToolkit toolkit, Section section) {
        this.reviewsComposite = toolkit.createComposite((Composite)section);
        section.setClient((Control)this.reviewsComposite);
        this.reviewsComposite.setLayout((Layout)EditorUtil.createSectionClientLayout());
        this.getTaskEditorPage().registerDefaultDropListener((Control)section);
        this.createReviewsTable(toolkit, this.reviewsComposite);
        toolkit.paintBordersFor(this.reviewsComposite);
    }

    public boolean isReviewsSectionExpanded() {
        return this.section != null && this.section.isExpanded();
    }

    protected void openReview(OpenEvent event) {
        ArrayList<TaskReview> reviewsToOpen = new ArrayList<TaskReview>();
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        List items = selection.toList();
        for (Object item : items) {
            if (!(item instanceof TaskReview)) continue;
            reviewsToOpen.add((TaskReview)item);
        }
        if (reviewsToOpen.isEmpty()) {
            return;
        }
        for (TaskReview openThis : reviewsToOpen) {
            TasksUiUtil.openTask((String)openThis.getUrl());
        }
    }

    private static final class ReviewColumnSorter
    extends TableSorter {
        private final ReviewColumnLabelProvider labelProvider;

        public ReviewColumnSorter(ReviewColumnLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public int compare(TableViewer viewer, Object e1, Object e2, int columnIndex) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String name1 = this.labelProvider.getSortString(e1, columnIndex);
            String name2 = this.labelProvider.getSortString(e2, columnIndex);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

