/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.subclipse.ui.connector;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.subclipse.ui.GetChangeSetDialog;
import org.eclipse.mylyn.versions.core.ChangeSet;
import org.eclipse.mylyn.versions.core.ScmCore;
import org.eclipse.mylyn.versions.core.ScmRepository;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.mylyn.versions.ui.spi.ScmConnectorUi;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;

public class SVNConnectorUi
extends ScmConnectorUi {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.subclipse.ui";

    public ChangeSet getChangeSet(ScmRepository repository, IResource resource) {
        Assert.isNotNull((Object)resource);
        IProject project = resource.getProject();
        Assert.isNotNull((Object)project);
        ScmConnector scmConnector = ScmCore.getConnector((IResource)resource);
        Assert.isNotNull((Object)scmConnector);
        if (!SVNProviderPlugin.getTypeId().equals(scmConnector.getProviderId())) {
            throw new RuntimeException("No Subclipse connector: " + scmConnector.getProviderId());
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        GetChangeSetDialog dialog = new GetChangeSetDialog(null, project, (IProgressMonitor)monitor);
        int result = dialog.open();
        monitor.setCanceled(true);
        if (result == 0) {
            return dialog.getChangeSet();
        }
        return null;
    }
}

