/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AccessControlOriginatorEntity;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AccessControlRuleEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.AccessDeniedException;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotPermittedAttrException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.remotecse.RemoteCseService;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class RemoteCSEController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = Patterns.getDAO(request.getTargetId(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTargetId());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find the parent resource");
        }
        this.transaction.lock((Object)parentEntity);
        List acpsToCheck = null;
        List remoteCSEs = null;
        List subscriptions = null;
        if (parentEntity.getResourceType().intValue() == 5) {
            CSEBaseEntity cseB = (CSEBaseEntity)parentEntity;
            acpsToCheck = cseB.getAccessControlPolicies();
            remoteCSEs = cseB.getRemoteCses();
            subscriptions = cseB.getSubscriptions();
        }
        if (request.getFrom() == null) {
            throw new AccessDeniedException("No originator provided");
        }
        boolean newOriginator = false;
        if (this.originatorExists(request.getFrom())) {
            this.checkACP(acpsToCheck, request.getFrom(), Operation.CREATE);
        } else {
            newOriginator = true;
        }
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for RemoteCSE creation");
        }
        RemoteCSE remoteCse = null;
        try {
            remoteCse = request.getRequestContentType().equals("application/obj") ? (RemoteCSE)request.getContent() : (RemoteCSE)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content");
        }
        if (remoteCse == null) {
            throw new BadRequestException("Error in provided content");
        }
        RemoteCSEEntity remoteCseEntity = new RemoteCSEEntity();
        ControllerUtil.CreateUtil.fillEntityFromGenericResource((Resource)remoteCse, (ResourceEntity)remoteCseEntity);
        if (remoteCse.getNodeLink() != null) {
            throw new NotPermittedAttrException("NodeLink is Not Permitted");
        }
        if (remoteCse.getCSEBase() == null) {
            throw new BadRequestException("CseBase is Mandatory");
        }
        remoteCseEntity.setRemoteCseUri(remoteCse.getCSEBase());
        if (remoteCse.getCSEID() == null) {
            throw new BadRequestException("CSE-ID is mandatory");
        }
        remoteCseEntity.setRemoteCseId(remoteCse.getCSEID());
        if (remoteCse.isRequestReachability() == null) {
            throw new BadRequestException("Request Reachability is mandatory");
        }
        remoteCseEntity.setRequestReachability(remoteCse.isRequestReachability().booleanValue());
        if (!remoteCse.getAccessControlPolicyIDs().isEmpty()) {
            remoteCseEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(remoteCse.getAccessControlPolicyIDs(), this.transaction));
        } else {
            remoteCseEntity.getAccessControlPolicies().addAll(acpsToCheck);
        }
        if (!remoteCse.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            remoteCseEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(remoteCse.getDynamicAuthorizationConsultationIDs(), this.transaction));
        }
        if (remoteCse.getExpirationTime() != null) {
            remoteCseEntity.setExpirationTime(remoteCse.getExpirationTime());
        }
        if (!remoteCse.getLabels().isEmpty()) {
            remoteCseEntity.setLabelsEntitiesFromSring(remoteCse.getLabels());
        }
        if (!remoteCse.getAnnounceTo().isEmpty()) {
            remoteCseEntity.getAnnounceTo().addAll(remoteCse.getAnnounceTo());
        }
        if (!remoteCse.getAnnouncedAttribute().isEmpty()) {
            remoteCseEntity.getAnnouncedAttribute().addAll(remoteCse.getAnnouncedAttribute());
        }
        if (remoteCse.getCseType() != null) {
            remoteCseEntity.setCseType(remoteCse.getCseType());
        }
        if (!remoteCse.getPointOfAccess().isEmpty()) {
            remoteCseEntity.getPointOfAccess().addAll(remoteCse.getPointOfAccess());
        }
        if (remoteCse.getM2MExtID() != null) {
            remoteCseEntity.setM2mExtId(remoteCse.getM2MExtID());
        }
        if (remoteCse.getTriggerRecipientID() != null) {
            remoteCseEntity.setTriggerRecipientID(remoteCse.getTriggerRecipientID());
        }
        String generatedId = RemoteCSEController.generateId("", "");
        remoteCseEntity.setResourceID("/" + Constants.CSE_ID + "/" + "csr" + Constants.PREFIX_SEPERATOR + generatedId);
        if (remoteCse.getName() != null) {
            if (!Patterns.checkResourceName(remoteCse.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~#]|\\.)+");
            }
            remoteCseEntity.setName(remoteCse.getName());
        } else {
            remoteCseEntity.setName("csr_" + generatedId);
        }
        remoteCseEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + remoteCseEntity.getName());
        if (!UriMapper.addNewUri(remoteCseEntity.getHierarchicalURI(), remoteCseEntity.getResourceID(), 16)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        remoteCseEntity.setCreationTime(Util.DateUtil.now());
        remoteCseEntity.setLastModifiedTime(Util.DateUtil.now());
        remoteCseEntity.setParentID(parentEntity.getResourceID());
        remoteCseEntity.setParentCseBase((CSEBaseEntity)parentEntity);
        remoteCseEntity.setResourceType(16);
        if (newOriginator) {
            AccessControlPolicyEntity acpEntity = new AccessControlPolicyEntity();
            acpEntity.setCreationTime(Util.DateUtil.now());
            acpEntity.setLastModifiedTime(Util.DateUtil.now());
            acpEntity.setParentID("/" + Constants.CSE_ID);
            acpEntity.setResourceID("/" + Constants.CSE_ID + "/" + "acp" + Constants.PREFIX_SEPERATOR + RemoteCSEController.generateId());
            acpEntity.setName("acpcsr" + Constants.PREFIX_SEPERATOR + generatedId);
            acpEntity.setResourceType(1);
            AccessControlRuleEntity ruleEntity = new AccessControlRuleEntity();
            AccessControlOriginatorEntity originatorEntity = new AccessControlOriginatorEntity(Constants.ADMIN_REQUESTING_ENTITY);
            ruleEntity.getAccessControlOriginators().add(originatorEntity);
            ruleEntity.setCreate(true);
            ruleEntity.setRetrieve(true);
            ruleEntity.setUpdate(true);
            ruleEntity.setDelete(true);
            ruleEntity.setNotify(true);
            ruleEntity.setDiscovery(true);
            acpEntity.getSelfPrivileges().add(ruleEntity);
            ruleEntity = new AccessControlRuleEntity();
            ruleEntity.setCreate(true);
            ruleEntity.setRetrieve(true);
            ruleEntity.setUpdate(true);
            ruleEntity.setDelete(true);
            ruleEntity.setNotify(true);
            ruleEntity.setDiscovery(true);
            ruleEntity.getAccessControlOriginators().add(new AccessControlOriginatorEntity(request.getFrom()));
            ruleEntity.getAccessControlOriginators().add(new AccessControlOriginatorEntity(Constants.ADMIN_REQUESTING_ENTITY));
            acpEntity.getPrivileges().add(ruleEntity);
            acpEntity.setHierarchicalURI("/" + Constants.CSE_ID + "/" + acpEntity.getName());
            UriMapper.addNewUri(acpEntity.getHierarchicalURI(), acpEntity.getResourceID(), 1);
            this.dbs.getDAOFactory().getAccessControlPolicyDAO().create(this.transaction, (Object)acpEntity);
            AccessControlPolicyEntity acpDB = (AccessControlPolicyEntity)this.dbs.getDAOFactory().getAccessControlPolicyDAO().find(this.transaction, (Object)acpEntity.getResourceID());
            CSEBaseEntity cseBase = (CSEBaseEntity)this.dbs.getDAOFactory().getCSEBaseDAO().find(this.transaction, (Object)("/" + Constants.CSE_ID));
            cseBase.getChildAccessControlPolicies().add(acpDB);
            this.dbs.getDAOFactory().getCSEBaseDAO().update(this.transaction, (Object)cseBase);
            remoteCseEntity.getAccessControlPolicies().add(acpDB);
            remoteCseEntity.setGeneratedAcp(acpDB);
        }
        this.dbs.getDAOFactory().getRemoteCSEDAO().create(this.transaction, (Object)remoteCseEntity);
        RemoteCSEEntity csrDB = (RemoteCSEEntity)this.dbs.getDAOFactory().getRemoteCSEDAO().find(this.transaction, (Object)remoteCseEntity.getResourceID());
        remoteCSEs.add(csrDB);
        dao.update(this.transaction, (Object)parentEntity);
        for (DynamicAuthorizationConsultationEntity dace : csrDB.getDynamicAuthorizationConsultations()) {
            DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
            daceFromDB.getLinkedRemoteCSEEntities().add(csrDB);
            this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
        }
        this.transaction.commit();
        RemoteCseService.getInstance().addRemoteCseAndPublish(csrDB);
        Notifier.notify(subscriptions, (ResourceEntity)csrDB, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)csrDB);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        RemoteCSEEntity csrEntity = (RemoteCSEEntity)this.dbs.getDAOFactory().getRemoteCSEDAO().find(this.transaction, (Object)request.getTargetId());
        if (csrEntity == null) {
            throw new ResourceNotFoundException();
        }
        List acpList = csrEntity.getAccessControlPolicies();
        this.checkACP(acpList, request.getFrom(), request.getOperation());
        RemoteCSE csr = EntityMapperFactory.getRemoteCseMapper().mapEntityToResource(csrEntity, request);
        response.setContent((Object)csr);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        RemoteCSEEntity csrEntity = (RemoteCSEEntity)this.dbs.getDAOFactory().getRemoteCSEDAO().find(this.transaction, (Object)request.getTargetId());
        if (csrEntity == null) {
            throw new ResourceNotFoundException();
        }
        this.transaction.lock((Object)csrEntity);
        this.checkACP(csrEntity.getAccessControlPolicies(), request.getFrom(), Operation.UPDATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for RemoteCSE Update");
        }
        RemoteCSE csr = null;
        try {
            csr = request.getRequestContentType().equals("application/obj") ? (RemoteCSE)request.getContent() : (RemoteCSE)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (csr == null) {
            throw new BadRequestException("Error in provided content");
        }
        ControllerUtil.UpdateUtil.checkNotPermittedParameters((Resource)csr);
        if (csr.getCseType() != null) {
            throw new BadRequestException("CseType is NP");
        }
        if (csr.getCSEBase() != null) {
            throw new BadRequestException("CseBase is NP");
        }
        if (csr.getCSEID() != null) {
            throw new BadRequestException("CseID is NP");
        }
        if (csr.getNodeLink() != null) {
            throw new BadRequestException("NodeLink is NP");
        }
        RemoteCSE modifiedAttributes = new RemoteCSE();
        if (!csr.getLabels().isEmpty()) {
            csrEntity.setLabelsEntitiesFromSring(csr.getLabels());
            modifiedAttributes.getLabels().addAll(csr.getLabels());
        }
        if (!csr.getAccessControlPolicyIDs().isEmpty()) {
            for (AccessControlPolicyEntity acpe : csrEntity.getAccessControlPolicies()) {
                this.checkSelfACP(acpe, request.getFrom(), Operation.UPDATE);
            }
            csrEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(csr.getAccessControlPolicyIDs(), this.transaction));
            modifiedAttributes.getAccessControlPolicyIDs().addAll(csr.getAccessControlPolicyIDs());
        }
        if (!csr.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            csrEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(csr.getDynamicAuthorizationConsultationIDs(), this.transaction));
            for (DynamicAuthorizationConsultationEntity dace : csrEntity.getDynamicAuthorizationConsultations()) {
                DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
                daceFromDB.getLinkedRemoteCSEEntities().add(csrEntity);
                this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
            }
        }
        if (csr.getExpirationTime() != null) {
            csrEntity.setExpirationTime(csr.getExpirationTime());
            modifiedAttributes.setExpirationTime(csr.getExpirationTime());
        }
        if (!csr.getAnnounceTo().isEmpty()) {
            csrEntity.getAnnounceTo().clear();
            csrEntity.getAnnounceTo().addAll(csr.getAnnounceTo());
            modifiedAttributes.getAnnounceTo().addAll(csr.getAnnounceTo());
        }
        if (!csr.getAnnouncedAttribute().isEmpty()) {
            csrEntity.getAnnouncedAttribute().clear();
            csrEntity.getAnnouncedAttribute().addAll(csr.getAnnouncedAttribute());
            modifiedAttributes.getAnnouncedAttribute().addAll(csr.getAnnouncedAttribute());
        }
        if (!csr.getPointOfAccess().isEmpty()) {
            csrEntity.getPointOfAccess().clear();
            csrEntity.getPointOfAccess().addAll(csr.getPointOfAccess());
            modifiedAttributes.getPointOfAccess().addAll(csr.getPointOfAccess());
        }
        if (csr.getM2MExtID() != null) {
            csrEntity.setM2mExtId(csr.getM2MExtID());
            modifiedAttributes.setM2MExtID(csr.getM2MExtID());
        }
        if (csr.getTriggerRecipientID() != null) {
            csrEntity.setTriggerRecipientID(csr.getTriggerRecipientID());
            modifiedAttributes.setTriggerRecipientID(csr.getTriggerRecipientID());
        }
        if (csr.isRequestReachability() != null) {
            csrEntity.setRequestReachability(csr.isRequestReachability().booleanValue());
            modifiedAttributes.setRequestReachability(csr.isRequestReachability());
        }
        csrEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(csrEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        this.dbs.getDAOFactory().getRemoteCSEDAO().update(this.transaction, (Object)csrEntity);
        this.transaction.commit();
        Notifier.notify(csrEntity.getSubscriptions(), (ResourceEntity)csrEntity, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        RemoteCSEEntity csrEntity = (RemoteCSEEntity)this.dbs.getDAOFactory().getRemoteCSEDAO().find(this.transaction, (Object)request.getTargetId());
        if (csrEntity == null) {
            throw new ResourceNotFoundException();
        }
        this.transaction.lock((Object)csrEntity);
        this.checkACP(csrEntity.getAccessControlPolicies(), request.getFrom(), Operation.DELETE);
        UriMapper.deleteUri(csrEntity.getHierarchicalURI());
        Notifier.notifyDeletion(csrEntity.getSubscriptions(), (ResourceEntity)csrEntity);
        this.dbs.getDAOFactory().getRemoteCSEDAO().delete(this.transaction, (Object)csrEntity);
        this.transaction.commit();
        RemoteCseService.getInstance().removeRemoteCseAndPublish(csrEntity.getName());
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

