/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Date;
import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.DateDataPoint;
import org.eclipse.om2m.sdt.datapoints.TimeDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Clock
extends Module {
    private TimeDataPoint currentTime;
    private DateDataPoint currentDate;

    public Clock(String name, Domain domain, TimeDataPoint currentTime, DateDataPoint currentDate) {
        super(name, domain, (Identifiers)ModuleType.clock);
        if (currentDate == null || !currentDate.getShortDefinitionType().equals(DatapointType.currentDate.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong currentDate datapoint: " + currentDate);
        }
        this.currentDate = currentDate;
        currentDate.setDoc("Information of the current date");
        this.addDataPoint((DataPoint)currentDate);
        if (currentTime == null || !currentTime.getShortDefinitionType().equals(DatapointType.currentTime.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong currentTime datapoint: " + currentTime);
        }
        this.currentTime = currentTime;
        currentTime.setDoc("Information of the current time");
        this.addDataPoint((DataPoint)currentTime);
    }

    public Clock(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (TimeDataPoint)dps.get(DatapointType.currentTime.getShortName()), (DateDataPoint)dps.get(DatapointType.currentDate.getShortName()));
    }

    public Date getCurrentTime() throws DataPointException, AccessException {
        return (Date)this.currentTime.getValue();
    }

    public String getStringCurrentTime() throws DataPointException, AccessException {
        return this.currentTime.getStringValue();
    }

    public void setCurrentTime(Date value) throws DataPointException, AccessException {
        this.currentTime.setValue((Object)value);
    }

    public Date getCurrentDate() throws DataPointException, AccessException {
        return (Date)this.currentDate.getValue();
    }

    public String getStringCurrentDate() throws DataPointException, AccessException {
        return this.currentDate.getStringValue();
    }

    public void setCurrentDate(Date value) throws DataPointException, AccessException {
        this.currentDate.setValue((Object)value);
    }
}

