/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.dal.driver.sample.fan.function;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.dal.driver.custom.functions.BaseFunction;
import org.eclipse.om2m.dal.driver.custom.functions.OperationMetadataImpl;
import org.eclipse.om2m.dal.driver.sample.Activator;
import org.osgi.service.dal.DeviceException;
import org.osgi.service.dal.FunctionData;
import org.osgi.service.dal.FunctionEvent;
import org.osgi.service.dal.PropertyMetadata;
import org.osgi.service.dal.functions.MultiLevelControl;
import org.osgi.service.dal.functions.data.LevelData;
import org.osgi.service.event.Event;

public class Countdown
extends BaseFunction
implements MultiLevelControl {
    private static Log LOGGER = LogFactory.getLog(Countdown.class);
    private static final int ONE_SENCOND = 100;
    private static final int ONE_MINUTE = 60;
    public static final BigDecimal MIN_VALUE = new BigDecimal(0);
    public static final BigDecimal MAX_VALUE = new BigDecimal(5);
    private static final BigDecimal STEP = new BigDecimal(1);
    private static final String OPERATION_INCREASE = "increase";
    private static final String OPERATION_REDUCE = "reduce";
    private CountdownMetadata countdownMetadata;
    private BigDecimal data = MIN_VALUE;
    private int countdownSec = 0;

    public Countdown(String devUid, String funcId) {
        super(devUid, "fancountdown", funcId);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                    if (Countdown.this.data.compareTo(MIN_VALUE) <= 0) continue;
                    Countdown countdown = Countdown.this;
                    int n = countdown.countdownSec - 1;
                    countdown.countdownSec = n;
                    if (n % 60 != 0) continue;
                    Countdown.this.data = Countdown.this.data.subtract(STEP);
                    Activator.getEventAdmin().postEvent((Event)new FunctionEvent("org/osgi/service/dal/FunctionEvent/PROPERTY_CHANGED", Countdown.this.uid, "data", (FunctionData)new LevelData(System.currentTimeMillis(), Countdown.this.countdownMetadata.getMetadata(null), Countdown.this.data, "")));
                    LOGGER.info((Object)("Function event(" + Countdown.this.uid + "-" + Countdown.this.data + ") is sent."));
                }
            }
        }.start();
    }

    public LevelData getData() throws DeviceException {
        return new LevelData(System.currentTimeMillis(), this.countdownMetadata.getMetadata(null), this.data, "");
    }

    public void setData(BigDecimal level, String unit) throws DeviceException {
        if (level.compareTo(MIN_VALUE) < 0 || level.compareTo(MAX_VALUE) > 0) {
            throw new DeviceException(String.format("Input level is out of scope [%s, %s]!", MIN_VALUE.toString(), MAX_VALUE.toString()));
        }
        this.data = level;
        this.countdownSec = this.data.intValue() * 60;
        Activator.getEventAdmin().postEvent((Event)new FunctionEvent("org/osgi/service/dal/FunctionEvent/PROPERTY_CHANGED", this.uid, "data", (FunctionData)new LevelData(System.currentTimeMillis(), this.countdownMetadata.getMetadata(null), this.data, "")));
        LOGGER.info((Object)("Function event (" + this.uid + "-" + this.data + ") is sent."));
    }

    @Override
    protected void setupFuncProperties() {
        this.props.put("dal.function.version", "1.0");
        this.props.put("dal.function.description", "AudioVolume function");
        this.props.put("dal.function.operation.names", new String[]{OPERATION_INCREASE, OPERATION_REDUCE});
        this.props.put("dal.function.property.names", new String[]{"data"});
    }

    public void increase() throws DeviceException {
        this.setData(this.data.add(STEP), "");
    }

    public void reduce() throws DeviceException {
        this.setData(this.data.subtract(STEP), "");
    }

    @Override
    protected void setupPropertyMetadata() {
        this.countdownMetadata = new CountdownMetadata();
        this.propMetadatas.put("data", this.countdownMetadata);
    }

    @Override
    protected void setupOperationMetadata() {
        this.oprMetadatas.put(OPERATION_INCREASE, new OperationMetadataImpl("Increase the value of count down clock", null, null));
        this.oprMetadatas.put(OPERATION_REDUCE, new OperationMetadataImpl("Reduce the value of count down clock", null, null));
    }

    private class CountdownMetadata
    implements PropertyMetadata {
        private Map<String, Object> metadatas = new Hashtable<String, Object>();

        public CountdownMetadata() {
            this.metadatas.put("access", new Integer(7));
            this.metadatas.put("description", "The current value of count down clock.");
            this.metadatas.put("units", new String[]{"Minute"});
        }

        public Map getMetadata(String unit) {
            return this.metadatas;
        }

        public FunctionData getStep(String unit) {
            return new LevelData(0L, this.metadatas, STEP, "");
        }

        public FunctionData[] getEnumValues(String unit) {
            return null;
        }

        public FunctionData getMinValue(String unit) {
            return new LevelData(0L, this.metadatas, MIN_VALUE, "");
        }

        public FunctionData getMaxValue(String unit) {
            return new LevelData(0L, this.metadatas, MAX_VALUE, "");
        }
    }
}

