/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public abstract class FlexContainerTestSuite {
    private final CseService cseService;
    private final List<TestReport> reports = new ArrayList<TestReport>();

    public FlexContainerTestSuite(CseService pCseService) {
        this.cseService = pCseService;
    }

    protected abstract String getTestSuiteName();

    public CseService getCseService() {
        return this.cseService;
    }

    public void executeTests() {
        Method[] methods;
        Method[] methodArray = methods = this.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("test")) {
                try {
                    method.invoke((Object)this, null);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public void executeTestsAndPrintReports() {
        this.executeTests();
        this.printTestReports();
    }

    protected ResponsePrimitive sendCreateFlexContainerRequest(AbstractFlexContainer flexContainer, String resourceLocation, String from) {
        return this.sendCreateRequest(resourceLocation, 28, (Resource)flexContainer, from);
    }

    protected ResponsePrimitive sendCreateFlexContainerRequest(AbstractFlexContainer flexContainer, String resourceLocation) {
        return this.sendCreateRequest(resourceLocation, 28, (Resource)flexContainer, Constants.ADMIN_REQUESTING_ENTITY);
    }

    protected ResponsePrimitive sendCreateSubscriptionRequest(Subscription subscription, String resourceLocation, String returnContentType) {
        return this.sendCreateRequest(resourceLocation, 23, (Resource)subscription, Constants.ADMIN_REQUESTING_ENTITY, "application/obj", returnContentType);
    }

    protected ResponsePrimitive sendCreateAccessControlPolicyRequest(AccessControlPolicy policy, String resourceLocation) {
        return this.sendCreateRequest(resourceLocation, 1, (Resource)policy, Constants.ADMIN_REQUESTING_ENTITY);
    }

    private ResponsePrimitive sendCreateRequest(String resourceLocation, int resourceType, Resource resource, String from) {
        return this.sendCreateRequest(resourceLocation, resourceType, resource, from, "application/obj", "application/obj");
    }

    private ResponsePrimitive sendCreateRequest(String resourceLocation, int resourceType, Resource resource, String from, String requestContentType, String returnContentType) {
        RequestPrimitive request = new RequestPrimitive();
        request.setContent((Object)resource);
        request.setFrom(from);
        request.setTargetId(resourceLocation);
        request.setTo(resourceLocation);
        request.setResourceType(BigInteger.valueOf(resourceType));
        request.setRequestContentType(requestContentType);
        request.setReturnContentType(returnContentType);
        request.setOperation(Operation.CREATE);
        ResponsePrimitive response = this.cseService.doRequest(request);
        return response;
    }

    protected ResponsePrimitive sendUpdateFlexContainerRequest(String resourceLocation, AbstractFlexContainer flexContainer) {
        return this.sendUpdateRequest(resourceLocation, 28, (Resource)flexContainer);
    }

    protected ResponsePrimitive sendUpdateSubscriptionRequest(String resourceLocation, Subscription subscription) {
        return this.sendUpdateRequest(resourceLocation, 23, (Resource)subscription);
    }

    protected ResponsePrimitive sendUpdateRequest(String resourceLocation, int resourceType, Resource resource) {
        RequestPrimitive request = new RequestPrimitive();
        request.setContent((Object)resource);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(resourceLocation);
        request.setTo(resourceLocation);
        request.setResourceType(BigInteger.valueOf(resourceType));
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.UPDATE);
        ResponsePrimitive response = this.cseService.doRequest(request);
        return response;
    }

    protected ResponsePrimitive sendRetrieveRequest(String resourceLocation) {
        return this.sendRetrieveRequest(resourceLocation, Constants.ADMIN_REQUESTING_ENTITY);
    }

    protected ResponsePrimitive sendRetrieveRequest(String resourceLocation, String from) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(from);
        request.setTargetId(resourceLocation);
        request.setTo(resourceLocation);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.RETRIEVE);
        request.setResultContent(ResultContent.ATTRIBUTES_AND_CHILD_REF);
        ResponsePrimitive response = this.cseService.doRequest(request);
        return response;
    }

    protected ResponsePrimitive sendDeleteRequest(String resourceLocation) {
        return this.sendDeleteRequest(resourceLocation, Constants.ADMIN_REQUESTING_ENTITY);
    }

    protected ResponsePrimitive sendDeleteRequest(String resourceLocation, String from) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(from);
        request.setTargetId(resourceLocation);
        request.setTo(resourceLocation);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.DELETE);
        ResponsePrimitive response = this.cseService.doRequest(request);
        return response;
    }

    protected void checkFlexContainer(AbstractFlexContainer initial, AbstractFlexContainer toBeCompared) throws Exception {
        this.checkFlexContainerName(initial, toBeCompared);
        this.checkFlexContainerDefinition(initial, toBeCompared);
        this.checkFlexContainerOntologyRef(initial, toBeCompared);
        this.checkFlexContainerCreator(initial, toBeCompared);
        this.checkFlexContainerCustomAttribute(initial, toBeCompared);
    }

    protected void checkFlexContainerName(AbstractFlexContainer initial, AbstractFlexContainer toBeCompared) throws Exception {
        if (!initial.getName().equals(toBeCompared.getName())) {
            throw new Exception("name are not equal");
        }
    }

    protected void checkFlexContainerDefinition(AbstractFlexContainer initial, AbstractFlexContainer toBeCompared) throws Exception {
        if (!initial.getContainerDefinition().equals(toBeCompared.getContainerDefinition())) {
            throw new Exception("containerDefinition are not equal");
        }
    }

    protected void checkFlexContainerOntologyRef(AbstractFlexContainer initial, AbstractFlexContainer toBeCompared) throws Exception {
        if (initial.getOntologyRef() == null && toBeCompared.getOntologyRef() != null) {
            throw new Exception("ontologyRef are not equal");
        }
        if (initial.getOntologyRef() != null && !initial.getOntologyRef().equals(toBeCompared.getOntologyRef())) {
            throw new Exception("ontologyRef are not equal");
        }
    }

    protected void checkFlexContainerCreator(AbstractFlexContainer initial, AbstractFlexContainer toBeCompared) throws Exception {
        if (initial.getCreator() == null && toBeCompared.getCreator() != null) {
            throw new Exception("creator are not equal");
        }
        if (initial.getCreator() != null && !initial.getCreator().equals(toBeCompared.getCreator())) {
            throw new Exception("creator are not equal");
        }
    }

    protected void checkFlexContainerCustomAttribute(AbstractFlexContainer initial, AbstractFlexContainer toBeCompared) throws Exception {
        if (initial.getCustomAttributes().size() != toBeCompared.getCustomAttributes().size()) {
            throw new Exception("customAttributes list size are not equal");
        }
        for (CustomAttribute ca : initial.getCustomAttributes()) {
            CustomAttribute foundCa = null;
            for (CustomAttribute caOfToBeCompared : toBeCompared.getCustomAttributes()) {
                if (!caOfToBeCompared.getCustomAttributeName().equals(ca.getCustomAttributeName())) continue;
                foundCa = caOfToBeCompared;
                break;
            }
            this.checkCustomAttribute(ca, foundCa);
        }
    }

    protected void checkCustomAttribute(CustomAttribute initialCa, CustomAttribute toBeComparedCa) throws Exception {
        if (!initialCa.getCustomAttributeName().equals(toBeComparedCa.getCustomAttributeName())) {
            throw new Exception("customAttributeName are differents (initialCaName=" + initialCa.getCustomAttributeName() + ", toBeComparedCaName=" + toBeComparedCa.getCustomAttributeName());
        }
        if (initialCa.getCustomAttributeValue() == null && toBeComparedCa.getCustomAttributeValue() != null) {
            throw new Exception("initialCa value is null but toBeComparedCa value is not null");
        }
        if (!initialCa.getCustomAttributeValue().equals(toBeComparedCa.getCustomAttributeValue())) {
            throw new Exception("customAttributeValue are differents (initialCaType=" + initialCa.getCustomAttributeValue() + ", toBeComparedCaType=" + toBeComparedCa.getCustomAttributeValue());
        }
    }

    protected void createTestReport(String methodName, TestReport.Status status, String message, Exception e) {
        TestReport tr = new TestReport(methodName, status, message, e);
        this.reports.add(tr);
    }

    protected void printTestReports() {
        System.out.println("\n\n" + this.getTestSuiteName() + "\n");
        for (TestReport tr : this.reports) {
            System.out.println(tr.toString());
            if (tr.getException() == null) continue;
            tr.getException().printStackTrace();
        }
    }
}

