/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.CseUtil;
import org.eclipse.om2m.ipe.sdt.SDTModuleAdaptor;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;

public class SDTDeviceAdaptor {
    private static Log logger = LogFactory.getLog(SDTDeviceAdaptor.class);
    private static final String SEP = "/";
    private static final String DEVICE_PREFIX = "DEVICE_";
    private final boolean hasToBeAnnounced;
    private final String parentLocation;
    private final String resourceLocation;
    private final String resourceName;
    private final Device device;
    private final String adminAcpResource;
    private final CseService cseService;
    private final String announceCseId;
    private final String remoteCseName;
    private boolean isPublished = false;
    private final Map<Module, SDTModuleAdaptor> modules;

    public SDTDeviceAdaptor(String pParentLocation, Device pDevice, CseService pCseService, String pAdminAcpResource, String pAnnounceCseId, String pRemoteCseName, boolean hasToBeAnnounced) {
        this.parentLocation = pParentLocation;
        this.hasToBeAnnounced = hasToBeAnnounced;
        this.device = pDevice;
        this.resourceName = DEVICE_PREFIX + this.device.getId();
        this.resourceLocation = String.valueOf(this.parentLocation) + SEP + this.resourceName;
        this.cseService = pCseService;
        this.announceCseId = pAnnounceCseId;
        this.remoteCseName = pRemoteCseName;
        this.adminAcpResource = pAdminAcpResource;
        this.modules = new HashMap<Module, SDTModuleAdaptor>();
    }

    public boolean publishIntoOM2MTree() {
        logger.info((Object)("publishIntoOM2MTree(flexContainerName=" + this.resourceName + ", parentLocation:" + this.parentLocation));
        AbstractFlexContainer flexContainer = FlexContainerFactory.getSpecializationFlexContainer((String)this.device.getShortDefinitionName());
        flexContainer.setName(this.resourceName);
        flexContainer.setContainerDefinition(this.device.getDefinition());
        flexContainer.setLongName(this.device.getLongDefinitionName());
        flexContainer.setShortName(this.device.getShortDefinitionName());
        flexContainer.getAccessControlPolicyIDs().add(this.adminAcpResource);
        if (this.hasToBeAnnounced) {
            flexContainer.getAnnounceTo().add(SEP + this.announceCseId);
        }
        flexContainer.getLabels().add("id/" + this.device.getId());
        flexContainer.getLabels().add("name/" + this.device.getName());
        flexContainer.getLabels().add("pid/" + this.device.getPid());
        flexContainer.getLabels().add("object.type/device");
        flexContainer.getLabels().add("cntDef/" + this.device.getDefinition());
        flexContainer.getLabels().add("OTB.CATEGORY/Read");
        this.isPublished = true;
        for (Property sdtProperty : this.device.getProperties()) {
            logger.debug((Object)("handle SDT Property (name=" + sdtProperty.getName() + ", value=" + sdtProperty.getValue() + ", type=" + sdtProperty.getType() + ")"));
            if (sdtProperty.getType() == null || sdtProperty.getValue() == null && sdtProperty.isOptional()) continue;
            CustomAttribute customAttributeForSdtProperty = new CustomAttribute();
            customAttributeForSdtProperty.setCustomAttributeName(sdtProperty.getShortName());
            customAttributeForSdtProperty.setCustomAttributeValue(sdtProperty.getValue());
            logger.info((Object)("new Property CustomAttribute (" + customAttributeForSdtProperty + ")"));
            flexContainer.getCustomAttributes().add(customAttributeForSdtProperty);
        }
        ResponsePrimitive response = CseUtil.sendCreateFlexContainerRequest(this.cseService, flexContainer, this.parentLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            logger.error((Object)("unable to create a FlexContainer for SDT Device " + this.resourceName + " : " + response.getContent()), null);
            return false;
        }
        for (Module module : this.device.getModules()) {
            SDTModuleAdaptor sdtModuleAdaptor = new SDTModuleAdaptor(module, this.cseService, this.resourceLocation, this.announceCseId, this.hasToBeAnnounced);
            if (sdtModuleAdaptor.publishModuleIntoOM2MTree()) {
                this.modules.put(module, sdtModuleAdaptor);
                continue;
            }
            logger.error((Object)("unable to publish module " + module.getName()), null);
            this.unpublishIntoOM2MTree();
            return false;
        }
        return true;
    }

    public void unpublishIntoOM2MTree() {
        logger.info((Object)("unpublish SDT Device (flexContainerLocation=" + this.resourceLocation + ")"));
        for (SDTModuleAdaptor module : this.modules.values()) {
            module.unpublishModuleFromOM2MTree();
        }
        CseUtil.sendDeleteRequest(this.cseService, this.resourceLocation);
    }
}

