/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.WaterSensorFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class WaterSensorModuleTest
extends AbstractModuleTest {
    public WaterSensorModuleTest(CseService pCseService, Module pModule) {
        super(pCseService, pModule);
    }

    public TestReport testGetAlarm() {
        TestReport report = new TestReport("Test module " + this.getModule().getName() + ".getAlarm()");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), this.getModuleUrl());
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer for module " + this.getModule() + " : " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        WaterSensorFlexContainer retrievedFlexContainer = (WaterSensorFlexContainer)response.getContent();
        CustomAttribute alarmCA = retrievedFlexContainer.getCustomAttribute(DatapointType.alarm.getShortName());
        if (alarmCA == null) {
            report.setErrorMessage("alarm customAttribute is missing but it is mandatory");
            report.setState(TestReport.State.KO);
            return report;
        }
        Boolean alarmValueFromFlexContainer = null;
        if (alarmCA.getCustomAttributeValue() == null) {
            report.setErrorMessage("alarm customAttribute value is null");
            report.setState(TestReport.State.KO);
            return report;
        }
        try {
            alarmValueFromFlexContainer = Boolean.valueOf(alarmCA.getCustomAttributeValue());
        }
        catch (ClassCastException e) {
            report.setErrorMessage("alarm customAttribute value is not a Boolean value (" + alarmCA.getCustomAttributeValue() + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        BooleanDataPoint alarmDP = (BooleanDataPoint)this.getModule().getDataPoint(DatapointType.alarm.getShortName());
        Boolean alarmValueFromDP = null;
        try {
            alarmValueFromDP = (Boolean)alarmDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve alarm value from Datapoint : " + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!this.checkObject(alarmValueFromFlexContainer, alarmValueFromDP, report, DatapointType.alarm.getShortName())) {
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testSetAlarm() {
        TestReport report = new TestReport("Test module " + this.getModule().getName() + ".setAlarm()");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        BooleanDataPoint alarmDP = (BooleanDataPoint)this.getModule().getDataPoint(DatapointType.alarm.getShortName());
        Boolean alarmValueFromDP = null;
        try {
            alarmValueFromDP = (Boolean)alarmDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve alarm DataPoint value:" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        WaterSensorFlexContainer toBeUpdated = new WaterSensorFlexContainer();
        CustomAttribute alarmCA = new CustomAttribute();
        alarmCA.setCustomAttributeName(DatapointType.alarm.getShortName());
        alarmCA.setCustomAttributeValue(Boolean.valueOf(alarmValueFromDP == false).toString());
        toBeUpdated.getCustomAttributes().add(alarmCA);
        ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.getModuleUrl(), (AbstractFlexContainer)toBeUpdated);
        if (ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("alarm is not writable, KO expected");
            report.setState(TestReport.State.KO);
            return report;
        }
        Boolean currentValueFromDP = null;
        response = CSEUtil.retrieveEntity(this.getCseService(), this.getModuleUrl());
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer: " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        WaterSensorFlexContainer retrievedFlexContainer = (WaterSensorFlexContainer)response.getContent();
        CustomAttribute ca = retrievedFlexContainer.getCustomAttribute(DatapointType.alarm.getShortName());
        try {
            currentValueFromDP = Boolean.parseBoolean(ca.getCustomAttributeValue());
        }
        catch (Exception e) {
            report.setErrorMessage("unable to retrieve alarm customAttribute value:" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!this.checkObject(alarmValueFromDP, currentValueFromDP, report, DatapointType.alarm.getShortName())) {
            return report;
        }
        report.setState(TestReport.State.OK);
        report.setErrorMessage("not implemented");
        return report;
    }
}

