/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.ae;

import java.util.ArrayList;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;
import org.eclipse.om2m.das.testsuite.ae.AbstractDASServiceTest;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.osgi.framework.ServiceRegistration;

public class DASServiceTest_Ae
extends AbstractDASServiceTest {
    public DASServiceTest_Ae(CseService pCseService) {
        super("DasServiceTest_Ae", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS(this.getDasAE().getResourceID());
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create dac");
            return;
        }
        this.setExpectedNumberOfCall(1);
        ServiceRegistration<InterworkingService> interworkingServiceRegistration = this.registerInterworkingService(this);
        ArrayList<String> dacis = new ArrayList<String>();
        dacis.add(dac.getResourceID());
        AE ae = this.createAE(dacis);
        if (ae == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create AE");
            return;
        }
        ResponsePrimitive response = this.retrieveEntity(ae.getResourceID(), "nom:password");
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve Ae, expecting " + ResponseStatusCode.OK + ", found =" + response.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, ae.getResourceID(), "nom:password", Operation.RETRIEVE)) {
            return;
        }
        this.clearCalls();
        AE toBeUpdated = new AE();
        toBeUpdated.setRequestReachability(Boolean.TRUE);
        RequestPrimitive updateRequest = new RequestPrimitive();
        updateRequest.setOperation(Operation.UPDATE);
        updateRequest.setFrom("nini:nono");
        updateRequest.setTargetId(ae.getResourceID());
        updateRequest.setRequestContentType("application/obj");
        updateRequest.setReturnContentType("application/obj");
        updateRequest.setContent((Object)toBeUpdated);
        ResponsePrimitive updateResponse = this.getCseService().doRequest(updateRequest);
        if (updateResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("updateResponse is null");
            return;
        }
        if (!ResponseStatusCode.UPDATED.equals(updateResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to update Ae, expecting " + ResponseStatusCode.UPDATED + ", found =" + updateResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, ae.getResourceID(), "nini:nono", Operation.UPDATE)) {
            return;
        }
        this.clearCalls();
        RequestPrimitive deleteRequest = new RequestPrimitive();
        deleteRequest.setOperation(Operation.DELETE);
        deleteRequest.setTargetId(ae.getResourceID());
        deleteRequest.setFrom("zaza:zozo");
        ResponsePrimitive deleteResponse = this.getCseService().doRequest(deleteRequest);
        if (deleteResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("deleteResponse is null");
            return;
        }
        if (!ResponseStatusCode.DELETED.equals(deleteResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete Ae, expecting " + ResponseStatusCode.DELETED + ", found =" + deleteResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, ae.getResourceID(), "zaza:zozo", Operation.DELETE)) {
            return;
        }
        this.unregisterInterworkingService(interworkingServiceRegistration);
        this.setState(Test.State.OK);
    }
}

