/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.dacis;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.FlexContainer;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class FlexContainerDacisTest
extends Test {
    public FlexContainerDacisTest(CseService pCseService) {
        super("FlexContainer dacis", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS();
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create DAC");
            return;
        }
        String flexContainerName = "flexContainer" + UUID.randomUUID();
        FlexContainer toBeCreatedFlexContainer = new FlexContainer();
        toBeCreatedFlexContainer.setContainerDefinition("mydef");
        toBeCreatedFlexContainer.getDynamicAuthorizationConsultationIDs().add(dac.getResourceID());
        toBeCreatedFlexContainer.setName(flexContainerName);
        RequestPrimitive createRequest = new RequestPrimitive();
        createRequest.setOperation(Operation.CREATE);
        createRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        createRequest.setTargetId("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        createRequest.setRequestContentType("application/obj");
        createRequest.setReturnContentType("application/obj");
        createRequest.setResourceType(28);
        createRequest.setContent((Object)toBeCreatedFlexContainer);
        ResponsePrimitive createResponse = this.getCseService().doRequest(createRequest);
        if (createResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("response is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(createResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create FlexContainer:expecting " + ResponseStatusCode.CREATED + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        FlexContainer createdFlexContainer = null;
        try {
            createdFlexContainer = (FlexContainer)createResponse.getContent();
        }
        catch (ClassCastException e) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a FlexContainer");
            return;
        }
        if (!this.checkEquals(createdFlexContainer.getDynamicAuthorizationConsultationIDs(), toBeCreatedFlexContainer.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        ResponsePrimitive retrieveResponse = this.retrieveEntity(createdFlexContainer.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve FlexContainer:expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        FlexContainer retrievedFlexContainer = null;
        try {
            retrievedFlexContainer = (FlexContainer)retrieveResponse.getContent();
        }
        catch (ClassCastException e) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a FlexContainer");
            return;
        }
        if (!this.checkEquals(retrievedFlexContainer.getDynamicAuthorizationConsultationIDs(), toBeCreatedFlexContainer.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        RequestPrimitive deleteRequest = new RequestPrimitive();
        deleteRequest.setOperation(Operation.DELETE);
        deleteRequest.setTargetId(dac.getResourceID());
        deleteRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        ResponsePrimitive deleteResponse = this.getCseService().doRequest(deleteRequest);
        if (!ResponseStatusCode.DELETED.equals(deleteResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete DAC");
            return;
        }
        retrieveResponse = this.retrieveEntity(createdFlexContainer.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve FlexContainer:expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        retrievedFlexContainer = null;
        try {
            retrievedFlexContainer = (FlexContainer)retrieveResponse.getContent();
        }
        catch (ClassCastException e) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a FlexContainer");
            return;
        }
        if (!this.checkEquals(retrievedFlexContainer.getDynamicAuthorizationConsultationIDs(), new ArrayList(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        this.setState(Test.State.OK);
    }
}

