/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.Light;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedBinarySwitch;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedColour;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedFaultDetection;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedRunMode;
import org.eclipse.om2m.sdt.home.modules.ColourSaturation;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedLight
extends Light
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;

    public MockedLight(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.addModule(new MockedFaultDetection("faultDetection_" + id, domain));
        this.addModule(new MockedBinarySwitch("binarySwitch_" + id, domain));
        this.addModule(new MockedRunMode("runMode_" + id, domain));
        this.addModule(new MockedColour("colour_" + id, domain));
        this.addModule(new ColourSaturation("colourSaturation_" + id, domain, new IntegerDataPoint((Identifiers)DatapointType.colourSat){
            private Integer v;
            {
                this.v = new Integer((int)(Math.random() * 100.0));
            }

            public void doSetValue(Integer value) throws DataPointException {
                this.v = value;
            }

            public Integer doGetValue() throws DataPointException {
                return this.v;
            }
        }));
    }

    @Override
    public void registerDevice() {
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
    }

    @Override
    public void unregisterDevice() {
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

