/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.modules.AtmosphericPressureSensor;
import org.eclipse.om2m.sdt.home.modules.ExtendedCarbonDioxideSensor;
import org.eclipse.om2m.sdt.home.modules.Noise;
import org.eclipse.om2m.sdt.home.modules.RelativeHumidity;
import org.eclipse.om2m.sdt.home.modules.Temperature;
import org.eclipse.om2m.sdt.home.types.DeviceType;

public class WeatherStation
extends GenericDevice {
    private Temperature temperature;
    private RelativeHumidity relativeHumidity;
    private AtmosphericPressureSensor atmosphericPressureSensor;
    private Noise noise;
    private ExtendedCarbonDioxideSensor extendedCarbonDioxideSensor;

    public WeatherStation(String id, String serial, Domain domain) {
        super(id, serial, DeviceType.deviceWeatherStation, domain);
    }

    public void addModule(Module module) {
        if (module instanceof Temperature) {
            this.setTemperature((Temperature)module);
        } else if (module instanceof RelativeHumidity) {
            this.setRelativeHumidity((RelativeHumidity)module);
        } else if (module instanceof AtmosphericPressureSensor) {
            this.setAtmosphericPressureSensor((AtmosphericPressureSensor)module);
        } else if (module instanceof Noise) {
            this.setNoise((Noise)module);
        } else if (module instanceof ExtendedCarbonDioxideSensor) {
            this.setExtendedCarbonDioxideSensor((ExtendedCarbonDioxideSensor)module);
        } else {
            super.addModule(module);
        }
    }

    public void setTemperature(Temperature pTemperature) {
        this.temperature = pTemperature;
        super.addModule((Module)this.temperature);
    }

    public void unsetTemperature(Temperature pTemperature) {
        if (this.temperature != null) {
            this.removeModule(this.temperature.getName());
            this.temperature = null;
        }
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public void setRelativeHumidity(RelativeHumidity pRelativeHumidity) {
        this.relativeHumidity = pRelativeHumidity;
        super.addModule((Module)this.relativeHumidity);
    }

    public void unsetRelativeHumidity(RelativeHumidity pRelativeHumidity) {
        if (this.relativeHumidity != null) {
            this.removeModule(this.relativeHumidity.getName());
            this.relativeHumidity = null;
        }
    }

    public RelativeHumidity getRelativeHumidity() {
        return this.relativeHumidity;
    }

    public void setAtmosphericPressureSensor(AtmosphericPressureSensor pAtmosphericPressureSensor) {
        this.atmosphericPressureSensor = pAtmosphericPressureSensor;
        super.addModule((Module)this.atmosphericPressureSensor);
    }

    public void unsetAtmosphericPressureSensor(AtmosphericPressureSensor pAtmosphericPressureSensor) {
        if (this.atmosphericPressureSensor != null) {
            this.removeModule(this.atmosphericPressureSensor.getName());
            this.atmosphericPressureSensor = null;
        }
    }

    public AtmosphericPressureSensor getAtmosphericPressureSensor() {
        return this.atmosphericPressureSensor;
    }

    public void setNoise(Noise pNoise) {
        this.noise = pNoise;
        super.addModule((Module)this.noise);
    }

    public void unsetNoise(Noise noise) {
        if (noise != null) {
            this.removeModule(noise.getName());
            this.noise = null;
        }
    }

    public Noise getNoise() {
        return this.noise;
    }

    public void setExtendedCarbonDioxideSensor(ExtendedCarbonDioxideSensor pExtendedCarbonDioxideSensor) {
        this.extendedCarbonDioxideSensor = pExtendedCarbonDioxideSensor;
        super.addModule((Module)this.extendedCarbonDioxideSensor);
    }

    public void unsetExtendCarbonDioxideSensor(ExtendedCarbonDioxideSensor pExtendedCarbonDioxideSensor) {
        if (this.extendedCarbonDioxideSensor != null) {
            this.removeModule(this.extendedCarbonDioxideSensor.getName());
            this.extendedCarbonDioxideSensor = null;
        }
    }

    public ExtendedCarbonDioxideSensor getExtendedCarbonDioxideSensor() {
        return this.extendedCarbonDioxideSensor;
    }
}

