/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.types;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BasicType {
    private static Map<String, BasicType> values = new HashMap<String, BasicType>();
    public static final BasicType INTEGER = new BasicType("integer", Integer.class);
    public static final BasicType BOOLEAN = new BasicType("boolean", Boolean.class);
    public static final BasicType STRING = new BasicType("string", String.class);
    public static final BasicType BYTE = new BasicType("byte", Byte.class);
    public static final BasicType FLOAT = new BasicType("float", Float.class);
    public static final BasicType ENUM = new BasicType("enum", Enum.class);
    public static final BasicType DATE = new BasicType("date", Date.class);
    public static final BasicType TIME = new BasicType("time", Date.class);
    public static final BasicType DATETIME = new BasicType("datetime", Date.class);
    public static final BasicType BLOB = new BasicType("blob", byte[].class);
    public static final BasicType URI = new BasicType("uri", URI.class);
    private final String value;
    private final Class<?> clazz;

    protected BasicType(String v, Class<?> c) {
        this.value = v;
        this.clazz = c;
        values.put(v, this);
    }

    public String getValue() {
        return this.value;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public static BasicType getBasicType(String s) {
        return values.get(s);
    }

    public String toString() {
        return this.clazz.getSimpleName().toLowerCase();
    }
}

