/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotPermittedAttrException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AbstractFlexContainerAnnc;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.redirector.Redirector;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class FlexContainerAnncController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        Patterns patterns = new Patterns();
        DAO<?> dao = patterns.getDAO(request.getTo(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTo());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        this.transaction.lock((Object)parentEntity);
        List acpsToCheck = null;
        List childFlexContainerAnncs = null;
        List subscriptions = null;
        if (parentEntity.getResourceType().intValue() == 10002) {
            AeAnncEntity aeAnnc = (AeAnncEntity)parentEntity;
            acpsToCheck = aeAnnc.getAccessControlPolicies();
            childFlexContainerAnncs = aeAnnc.getFlexContainerAnncs();
            subscriptions = aeAnnc.getSubscriptions();
            aeAnnc.getDynamicAuthorizationConsultations();
        }
        if (parentEntity.getResourceType().intValue() == 10028) {
            FlexContainerAnncEntity parentFlexContainer = (FlexContainerAnncEntity)parentEntity;
            acpsToCheck = parentFlexContainer.getAccessControlPolicies();
            childFlexContainerAnncs = parentFlexContainer.getChildFlexContainerAnncs();
            subscriptions = parentFlexContainer.getSubscriptions();
            parentFlexContainer.getDynamicAuthorizationConsultations();
        }
        this.checkPermissions(request, parentEntity, acpsToCheck);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for FlexContainer creation");
        }
        AbstractFlexContainerAnnc flexContainerAnnc = null;
        try {
            flexContainerAnnc = request.getRequestContentType().equals("application/obj") ? (AbstractFlexContainerAnnc)request.getContent() : (AbstractFlexContainerAnnc)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            LOGGER.debug((Object)"ClassCastException: Incorrect resource type in object conversion.", (Throwable)e);
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (flexContainerAnnc == null) {
            throw new BadRequestException("Error in provided content");
        }
        FlexContainerAnncEntity flexContainerAnncEntity = new FlexContainerAnncEntity();
        ControllerUtil.CreateUtil.fillEntityFromGenericResource((Resource)flexContainerAnnc, (ResourceEntity)flexContainerAnncEntity);
        if (flexContainerAnnc.getLink() == null) {
            throw new BadRequestException("Link is Mandatory");
        }
        flexContainerAnncEntity.setLink(flexContainerAnnc.getLink());
        if (flexContainerAnnc.getExpirationTime() != null) {
            flexContainerAnncEntity.setExpirationTime(flexContainerAnncEntity.getExpirationTime());
        }
        if (flexContainerAnnc.getCreator() != null) {
            flexContainerAnncEntity.setCreator(flexContainerAnnc.getCreator());
        }
        if (flexContainerAnnc.getContainerDefinition() == null || flexContainerAnnc.getContainerDefinition().isEmpty()) {
            throw new NotPermittedAttrException("containerDefinition attribute must be provided.");
        }
        flexContainerAnncEntity.setContainerDefinition(flexContainerAnnc.getContainerDefinition());
        String generatedId = FlexContainerAnncController.generateId("", "");
        if (flexContainerAnnc.getName() != null) {
            if (!patterns.checkResourceName(flexContainerAnnc.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:" + patterns.ID_STRING);
            }
            flexContainerAnncEntity.setName(flexContainerAnnc.getName());
        } else {
            flexContainerAnncEntity.setName("fcnta_" + generatedId);
        }
        flexContainerAnncEntity.setLongName(flexContainerAnnc.getLongName());
        flexContainerAnncEntity.setShortName(flexContainerAnnc.getShortName());
        flexContainerAnncEntity.setResourceID("/" + Constants.CSE_ID + "/" + "fcnta" + Constants.PREFIX_SEPERATOR + generatedId);
        flexContainerAnncEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + flexContainerAnncEntity.getName());
        flexContainerAnncEntity.setParentID(parentEntity.getResourceID());
        flexContainerAnncEntity.setResourceType(10028);
        switch (parentEntity.getResourceType().intValue()) {
            case 10002: {
                flexContainerAnncEntity.setParentAeAnnc((AeAnncEntity)parentEntity);
                break;
            }
            case 10028: {
                flexContainerAnncEntity.setParentFlexContainerAnnc((FlexContainerAnncEntity)parentEntity);
            }
        }
        if (!flexContainerAnnc.getAccessControlPolicyIDs().isEmpty()) {
            flexContainerAnncEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(flexContainerAnnc.getAccessControlPolicyIDs(), this.transaction));
        } else {
            flexContainerAnncEntity.getAccessControlPolicies().addAll(acpsToCheck);
        }
        if (!flexContainerAnnc.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            flexContainerAnncEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(flexContainerAnnc.getDynamicAuthorizationConsultationIDs(), this.transaction));
        }
        if (!UriMapper.addNewUri(flexContainerAnncEntity.getHierarchicalURI(), flexContainerAnncEntity.getResourceID(), 10028)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        if (flexContainerAnnc.getOntologyRef() != null) {
            flexContainerAnncEntity.setOntologyRef(flexContainerAnnc.getOntologyRef());
        }
        this.dbs.getDAOFactory().getFlexContainerAnncDAO().create(this.transaction, (Object)flexContainerAnncEntity);
        FlexContainerAnncEntity flexContainerFromDB = (FlexContainerAnncEntity)this.dbs.getDAOFactory().getFlexContainerAnncDAO().find(this.transaction, (Object)flexContainerAnncEntity.getResourceID());
        childFlexContainerAnncs.add(flexContainerFromDB);
        dao.update(this.transaction, (Object)parentEntity);
        for (DynamicAuthorizationConsultationEntity dace : flexContainerFromDB.getDynamicAuthorizationConsultations()) {
            DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
            daceFromDB.getLinkedFlexContainerAnncEntities().add(flexContainerFromDB);
            this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
        }
        this.transaction.commit();
        Notifier.notify(subscriptions, (ResourceEntity)flexContainerFromDB, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)flexContainerFromDB);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        FlexContainerAnncEntity flexContainerAnncEntity = (FlexContainerAnncEntity)this.dbs.getDAOFactory().getFlexContainerAnncDAO().find(this.transaction, (Object)request.getTo());
        if (flexContainerAnncEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        flexContainerAnncEntity.getAccessControlPolicies();
        this.checkPermissions(request, (ResourceEntity)flexContainerAnncEntity, flexContainerAnncEntity.getAccessControlPolicies());
        if (ResultContent.ORIGINAL_RES.equals(request.getResultContent())) {
            RequestPrimitive originalResourceRequest = new RequestPrimitive();
            originalResourceRequest.setOperation(Operation.RETRIEVE);
            originalResourceRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
            originalResourceRequest.setTo(flexContainerAnncEntity.getLink());
            originalResourceRequest.setReturnContentType(request.getReturnContentType());
            return Redirector.retarget(originalResourceRequest);
        }
        AbstractFlexContainerAnnc flexContainerAnncResource = EntityMapperFactory.getFlexContainerAnncMapper().mapEntityToResource(flexContainerAnncEntity, request);
        response.setContent((Object)flexContainerAnncResource);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        FlexContainerAnncEntity flexContainerAnncEntity = (FlexContainerAnncEntity)this.dbs.getDAOFactory().getFlexContainerAnncDAO().find(this.transaction, (Object)request.getTo());
        if (flexContainerAnncEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)flexContainerAnncEntity);
        flexContainerAnncEntity.getAccessControlPolicies();
        this.checkPermissions(request, (ResourceEntity)flexContainerAnncEntity, flexContainerAnncEntity.getAccessControlPolicies());
        if (ResultContent.ORIGINAL_RES.equals(request.getResultContent())) {
            this.transaction.commit();
            RequestPrimitive originalResourceRequest = new RequestPrimitive();
            originalResourceRequest.setOperation(Operation.UPDATE);
            originalResourceRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
            originalResourceRequest.setTo(flexContainerAnncEntity.getLink());
            originalResourceRequest.setRequestContentType(request.getRequestContentType());
            originalResourceRequest.setReturnContentType(request.getReturnContentType());
            originalResourceRequest.setContent(request.getContent());
            return Redirector.retarget(originalResourceRequest);
        }
        ResponsePrimitive response = new ResponsePrimitive(request);
        AbstractFlexContainerAnnc modifiedAttributes = new AbstractFlexContainerAnnc();
        if (request.getContent() != null) {
            AbstractFlexContainerAnnc flexContainerAnnc = null;
            try {
                flexContainerAnnc = request.getRequestContentType().equals("application/obj") ? (AbstractFlexContainerAnnc)request.getContent() : (AbstractFlexContainerAnnc)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
            }
            catch (ClassCastException e) {
                throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
            }
            if (flexContainerAnnc == null) {
                throw new BadRequestException("Error in provided content");
            }
            if (!flexContainerAnnc.getAccessControlPolicyIDs().isEmpty()) {
                flexContainerAnncEntity.getAccessControlPolicies().clear();
                flexContainerAnncEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(flexContainerAnnc.getAccessControlPolicyIDs(), this.transaction));
                modifiedAttributes.getAccessControlPolicyIDs().addAll(flexContainerAnnc.getAccessControlPolicyIDs());
            }
            if (!flexContainerAnnc.getDynamicAuthorizationConsultationIDs().isEmpty()) {
                flexContainerAnncEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(flexContainerAnnc.getDynamicAuthorizationConsultationIDs(), this.transaction));
                for (DynamicAuthorizationConsultationEntity dace : flexContainerAnncEntity.getDynamicAuthorizationConsultations()) {
                    DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
                    daceFromDB.getLinkedFlexContainerAnncEntities().add(flexContainerAnncEntity);
                    this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
                }
            }
            if (!flexContainerAnnc.getLabels().isEmpty()) {
                flexContainerAnncEntity.setLabelsEntitiesFromSring(flexContainerAnnc.getLabels());
                modifiedAttributes.getLabels().addAll(flexContainerAnnc.getLabels());
            }
            if (flexContainerAnnc.getExpirationTime() != null) {
                flexContainerAnncEntity.setExpirationTime(flexContainerAnnc.getExpirationTime());
                modifiedAttributes.setExpirationTime(flexContainerAnnc.getExpirationTime());
            }
            if (flexContainerAnnc.getOntologyRef() != null) {
                flexContainerAnncEntity.setOntologyRef(flexContainerAnnc.getOntologyRef());
                modifiedAttributes.setOntologyRef(flexContainerAnnc.getOntologyRef());
            }
            if (flexContainerAnnc.getContainerDefinition() != null && !flexContainerAnncEntity.getContainerDefinition().equals(flexContainerAnnc.getContainerDefinition())) {
                throw new BadRequestException("unable to change the containerDefinition value");
            }
        }
        flexContainerAnncEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(flexContainerAnncEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        this.dbs.getDAOFactory().getFlexContainerAnncDAO().update(this.transaction, (Object)flexContainerAnncEntity);
        this.transaction.commit();
        Notifier.notify(flexContainerAnncEntity.getSubscriptions(), (ResourceEntity)flexContainerAnncEntity, (Resource)modifiedAttributes, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        FlexContainerAnncEntity flexContainerAnncEntity = (FlexContainerAnncEntity)this.dbs.getDAOFactory().getFlexContainerAnncDAO().find(this.transaction, (Object)request.getTo());
        if (flexContainerAnncEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)flexContainerAnncEntity);
        this.checkPermissions(request, (ResourceEntity)flexContainerAnncEntity, flexContainerAnncEntity.getAccessControlPolicies());
        UriMapper.deleteUri(flexContainerAnncEntity.getHierarchicalURI());
        Notifier.notifyDeletion(flexContainerAnncEntity.getSubscriptions(), (ResourceEntity)flexContainerAnncEntity);
        this.dbs.getDAOFactory().getFlexContainerAnncDAO().delete(this.transaction, (Object)flexContainerAnncEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

