/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.router;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.ResponseType;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.controller.AEAnncController;
import org.eclipse.om2m.core.controller.AEController;
import org.eclipse.om2m.core.controller.AccessControlPolicyController;
import org.eclipse.om2m.core.controller.CSEBaseController;
import org.eclipse.om2m.core.controller.ContainerController;
import org.eclipse.om2m.core.controller.ContentInstanceController;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.controller.DiscoveryController;
import org.eclipse.om2m.core.controller.DynamicAuthorizationConsultationController;
import org.eclipse.om2m.core.controller.FanOutPointController;
import org.eclipse.om2m.core.controller.FlexContainerAnncController;
import org.eclipse.om2m.core.controller.FlexContainerController;
import org.eclipse.om2m.core.controller.GroupController;
import org.eclipse.om2m.core.controller.LatestOldestController;
import org.eclipse.om2m.core.controller.NodeController;
import org.eclipse.om2m.core.controller.PollingChannelController;
import org.eclipse.om2m.core.controller.PollingChannelUriController;
import org.eclipse.om2m.core.controller.RemoteCSEController;
import org.eclipse.om2m.core.controller.RequestController;
import org.eclipse.om2m.core.controller.SubscriptionController;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.nblocking.NonBlockingHandler;
import org.eclipse.om2m.core.redirector.Redirector;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.core.urimapper.UriMapper;

public class Router
implements CseService {
    private static Log LOGGER = LogFactory.getLog(Router.class);

    public ResponsePrimitive doRequest(RequestPrimitive request) {
        ResponsePrimitive response;
        block31: {
            LOGGER.info((Object)("Received request in Router: " + request.toString()));
            response = new ResponsePrimitive(request);
            Patterns patterns = new Patterns();
            String contentFormat = System.getProperty("org.eclipse.om2m.registration.contentFormat", "application/xml");
            try {
                if (request.getResponseTypeInfo() != null && request.getResponseTypeInfo().getResponseType() != null && (request.getResponseTypeInfo().getResponseType().equals(ResponseType.NON_BLOCKING_REQUEST_SYNCH) || request.getResponseTypeInfo().getResponseType().equals(ResponseType.NON_BLOCKING_REQUEST_ASYNCH))) {
                    if (Constants.NON_BLOCKING_SUPPORTED) {
                        return NonBlockingHandler.handle(request);
                    }
                    response.setResponseStatusCode(ResponseStatusCode.NON_BLOCKING_REQUEST_NOT_SUPPORTED);
                    response.setContent((Object)"Non blocking request is not supported");
                    response.setContentType("text/plain");
                    return response;
                }
                if (request.getRequestContentType() == null) {
                    request.setRequestContentType(contentFormat);
                    LOGGER.info((Object)("No Content-Type parameter set, setting to default: " + request.getRequestContentType()));
                }
                if (request.getReturnContentType() == null) {
                    request.setReturnContentType(contentFormat);
                    LOGGER.info((Object)("No Accept parameter set, setting to default: " + request.getReturnContentType()));
                }
                if (request.getRequestContentType() != "application/obj" && request.getRequestContentType() != null && !DataMapperSelector.getDataMapperList().containsKey(request.getRequestContentType())) {
                    throw new NotImplementedException(String.valueOf(request.getRequestContentType()) + " is not supported.");
                }
                if (request.getReturnContentType() != "application/obj" && request.getReturnContentType() != null && !DataMapperSelector.getDataMapperList().containsKey(request.getReturnContentType())) {
                    throw new NotImplementedException(String.valueOf(request.getReturnContentType()) + " is not supported.");
                }
                if (request.getOperation() == null) {
                    throw new BadRequestException("No Operation provided");
                }
                if (request.getTo() == null) {
                    throw new BadRequestException("No To/TargetId parameter provided");
                }
                if (request.getTo().startsWith("~")) {
                    request.setTo(request.getTo().substring(1));
                }
                if (request.getTo().startsWith("//") || request.getTo().startsWith("_")) {
                    String uri = request.getTo().substring(2);
                    String spId = uri.split("/")[0];
                    if (!spId.equals(Constants.M2M_SP_ID)) {
                        throw new ResourceNotFoundException("Not the current SP Domain (" + spId + ")");
                    }
                    request.setTo(uri.replace(spId, ""));
                } else if (!request.getTo().startsWith("/")) {
                    request.setTo("/" + Constants.CSE_ID + "/" + request.getTo());
                }
                if (request.getTo().endsWith("/")) {
                    request.setTo(request.getTo().substring(0, request.getTo().length() - 1));
                }
                Router.getQueryStringFromTargetId(request);
                if (!patterns.match(patterns.NON_RETARGETING_PATTERN, request.getTo())) {
                    LOGGER.info((Object)("Request targeting another CSE, forwarding to Redirector: " + request.getTo()));
                    return Redirector.retarget(request);
                }
                LOGGER.info((Object)("Request handling in the current CSE: " + request.getTo()));
                Object controller = null;
                if (patterns.match(patterns.HIERARCHICAL_PATTERN, request.getTo())) {
                    String nonHierarchicalUri;
                    if (request.getTo().contains(String.valueOf(patterns.FANOUT_POINT_MATCH) + "/")) {
                        int foptIndex = request.getTo().indexOf(patterns.FANOUT_POINT_MATCH);
                        String uri = request.getTo().substring(0, foptIndex);
                        String suffix = request.getTo().substring(foptIndex + patterns.FANOUT_POINT_MATCH.length(), request.getTo().length());
                        controller = new FanOutPointController(suffix);
                        request.setTo(uri);
                        LOGGER.info((Object)("Fan Out request received: [grp uri: " + uri + ", suffix: " + suffix + "]"));
                    }
                    if (request.getTo().endsWith(patterns.FANOUT_POINT_MATCH)) {
                        controller = new FanOutPointController();
                        request.setTo(request.getTo().replaceAll(patterns.FANOUT_POINT_MATCH, ""));
                        LOGGER.info((Object)("Fan Out request received: [grp uri: " + request.getTo() + "]"));
                    }
                    if (request.getTo().endsWith("/la")) {
                        controller = new LatestOldestController(LatestOldestController.SortingPolicy.LATEST);
                        request.setTo(String.valueOf(request.getTo()) + "/");
                        request.setTo(request.getTo().replace("/la/", ""));
                    }
                    if (request.getTo().endsWith("/ol")) {
                        controller = new LatestOldestController(LatestOldestController.SortingPolicy.OLDEST);
                        request.setTo(String.valueOf(request.getTo()) + "/");
                        request.setTo(request.getTo().replace("/ol/", ""));
                    }
                    if ((nonHierarchicalUri = UriMapper.getNonHierarchicalUri(request.getTo())) == null) {
                        throw new ResourceNotFoundException("Resource not found");
                    }
                    request.setTo(nonHierarchicalUri);
                    LOGGER.debug((Object)("Changing to unstructured uri for routing to: " + request.getTo()));
                }
                if (request.getOperation().equals(Operation.NOTIFY)) {
                    return Redirector.retargetNotify(request);
                }
                if (request.getFilterCriteria() != null && request.getFilterCriteria().getFilterUsage() != null && request.getFilterCriteria().getFilterUsage().intValue() == 1) {
                    controller = new DiscoveryController();
                }
                if (controller == null) {
                    controller = request.getOperation().equals(Operation.CREATE) ? this.getResourceControllerFromRT(request.getResourceType()) : this.getResourceControllerFromURI(request.getTo());
                }
                if (controller != null) {
                    LOGGER.info((Object)("ResourceController to be used [" + controller.getClass().getSimpleName() + "]"));
                    response = ((Controller)controller).doRequest(request);
                    if (request.getResultContent() != null && request.getResultContent().equals(ResultContent.NOTHING)) {
                        response.setContent(null);
                    } else if (response.getContent() != null && !(response.getContent() instanceof String) && !request.getReturnContentType().equals("application/obj")) {
                        String representation = DataMapperSelector.getDataMapperList().get(request.getReturnContentType()).objToString(response.getContent());
                        response.setContent((Object)representation);
                        response.setContentType(request.getReturnContentType());
                    }
                    break block31;
                }
                throw new BadRequestException("Malformed URI");
            }
            catch (Om2mException om2mException) {
                response.setResponseStatusCode(om2mException.getErrorStatusCode());
                response.setContent((Object)om2mException.getMessage());
                response.setContentType("text/plain");
                LOGGER.error((Object)("OM2M exception caught in Router: " + om2mException.getMessage()), (Throwable)om2mException);
                LOGGER.debug((Object)"OM2M exception caught in Router", (Throwable)om2mException);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Router internal error", (Throwable)e);
                response.setResponseStatusCode(ResponseStatusCode.INTERNAL_SERVER_ERROR);
                response.setContent((Object)"Router internal error");
                response.setContentType("text/plain");
            }
        }
        LOGGER.info((Object)("Response in Router= " + response));
        return response;
    }

    protected Controller getResourceControllerFromURI(String uri) {
        Patterns patterns = new Patterns();
        if (patterns.match(patterns.CSE_BASE_PATTERN, uri)) {
            return new CSEBaseController();
        }
        if (patterns.match(patterns.AE_PATTERN, uri)) {
            return new AEController();
        }
        if (patterns.match(patterns.AEANNC_PATTERN, uri)) {
            return new AEAnncController();
        }
        if (patterns.match(patterns.ACP_PATTERN, uri)) {
            return new AccessControlPolicyController();
        }
        if (patterns.match(patterns.CONTAINER_PATTERN, uri)) {
            return new ContainerController();
        }
        if (patterns.match(patterns.DYNAMIC_AUTHORIZATION_CONSULTATION_PATTERN, uri)) {
            return new DynamicAuthorizationConsultationController();
        }
        if (patterns.match(patterns.FLEXCONTAINER_PATTERN, uri)) {
            return new FlexContainerController();
        }
        if (patterns.match(patterns.FLEXCONTAINER_ANNC_PATTERN, uri)) {
            return new FlexContainerAnncController();
        }
        if (patterns.match(patterns.CONTENTINSTANCE_PATTERN, uri)) {
            return new ContentInstanceController();
        }
        if (patterns.match(patterns.REMOTE_CSE_PATTERN, uri)) {
            return new RemoteCSEController();
        }
        if (patterns.match(patterns.GROUP_PATTERN, uri)) {
            return new GroupController();
        }
        if (patterns.match(patterns.NODE_PATTERN, uri)) {
            return new NodeController();
        }
        if (patterns.match(patterns.SUBSCRIPTION_PATTERN, uri)) {
            return new SubscriptionController();
        }
        if (patterns.match(patterns.POLLING_CHANNEL_PATTERN, uri)) {
            return new PollingChannelController();
        }
        if (patterns.match(patterns.POLLING_CHANNEL_URI_PATTERN, uri)) {
            return new PollingChannelUriController();
        }
        if (patterns.match(patterns.REQUEST_PATTERN, uri)) {
            return new RequestController();
        }
        return null;
    }

    protected Controller getResourceControllerFromRT(BigInteger resourceType) {
        if (resourceType == null) {
            throw new BadRequestException("Resource type is missing for creation request");
        }
        switch (resourceType.intValue()) {
            case 5: {
                return new CSEBaseController();
            }
            case 1: {
                return new AccessControlPolicyController();
            }
            case 2: {
                return new AEController();
            }
            case 3: {
                return new ContainerController();
            }
            case 4: {
                return new ContentInstanceController();
            }
            case 34: {
                return new DynamicAuthorizationConsultationController();
            }
            case 16: {
                return new RemoteCSEController();
            }
            case 9: {
                return new GroupController();
            }
            case 14: {
                return new NodeController();
            }
            case 23: {
                return new SubscriptionController();
            }
            case 15: {
                return new PollingChannelController();
            }
            case 28: {
                return new FlexContainerController();
            }
            case 10002: {
                return new AEAnncController();
            }
            case 10028: {
                return new FlexContainerAnncController();
            }
        }
        throw new NotImplementedException("ResourceType: " + resourceType + " is not implemented");
    }

    private static void getQueryStringFromTargetId(RequestPrimitive request) {
        if (request.getTo().contains("#")) {
            request.getQueryStrings().put("#", new ArrayList());
        }
        if (request.getTo().contains("?")) {
            String query = request.getTo().split("\\?")[1];
            HashMap parameters = new HashMap();
            if (query != null) {
                String[] pairs;
                String[] stringArray = pairs = query.split("[&]");
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] param = pair.split("[=]");
                    String key = null;
                    String value = null;
                    if (param.length > 0) {
                        key = param[0];
                    }
                    if (param.length > 1) {
                        value = param[1];
                    }
                    if (parameters.containsKey(key)) {
                        ((List)parameters.get(key)).add(value);
                    } else {
                        ArrayList<String> values = new ArrayList<String>();
                        values.add(value);
                        parameters.put(key, values);
                    }
                    ++n2;
                }
            }
            request.getQueryStrings().putAll(parameters);
        }
    }
}

