/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.crud;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class CreateDAS_CseBase_Test
extends Test {
    public CreateDAS_CseBase_Test(CseService pCseService) {
        super("CREATE DAS", pCseService);
    }

    protected CreateDAS_CseBase_Test(String pName, CseService pCseService) {
        super(pName, pCseService);
    }

    @Override
    public void performTest() {
        if (!this.createAndCheck("/" + Constants.CSE_ID)) {
            return;
        }
        if (!this.createAndCheck("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME)) {
            return;
        }
        this.setState(Test.State.OK);
    }

    protected boolean createAndCheck(String toBeCreatedDasUrl) {
        RequestPrimitive request = new RequestPrimitive();
        Boolean enabled = Boolean.TRUE;
        ArrayList<String> poa = new ArrayList<String>();
        poa.add("poa1");
        poa.add("poa2");
        String dasName = "DAS" + UUID.randomUUID().toString();
        request.setOperation(Operation.CREATE);
        request.setTo(toBeCreatedDasUrl);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setResourceType(34);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        DynamicAuthorizationConsultation das = new DynamicAuthorizationConsultation();
        das.setDynamicAuthorizationEnabled(enabled);
        das.setDynamicAuthorisationPoA(poa);
        das.setDynamicAuthorizationLifetime(new Date().toString());
        das.setName(dasName);
        request.setContent((Object)das);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        if (response != null) {
            if (ResponseStatusCode.CREATED.equals(response.getResponseStatusCode())) {
                DynamicAuthorizationConsultation createdDas;
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                block34: {
                                                    block33: {
                                                        block32: {
                                                            block31: {
                                                                block30: {
                                                                    block29: {
                                                                        block28: {
                                                                            block27: {
                                                                                block26: {
                                                                                    block25: {
                                                                                        block24: {
                                                                                            try {
                                                                                                createdDas = (DynamicAuthorizationConsultation)response.getContent();
                                                                                                if (this.checkNotNull(createdDas.getName(), "name")) break block24;
                                                                                                return false;
                                                                                            }
                                                                                            catch (ClassCastException classCastException) {
                                                                                                this.setState(Test.State.KO);
                                                                                                this.setMessage("unable to retrieve created DynamicAuthorizationConsultation as a Java object");
                                                                                                return false;
                                                                                            }
                                                                                        }
                                                                                        if (this.checkNotEmpty(createdDas.getName(), "name")) break block25;
                                                                                        return false;
                                                                                    }
                                                                                    if (this.checkNotNull(createdDas.getResourceType(), "resourceType")) break block26;
                                                                                    return false;
                                                                                }
                                                                                if (this.checkEquals(createdDas.getResourceType().intValue(), 34, "resourceType")) break block27;
                                                                                return false;
                                                                            }
                                                                            if (this.checkNotNull(createdDas.getResourceID(), "resourceID")) break block28;
                                                                            return false;
                                                                        }
                                                                        if (this.checkNotEmpty(createdDas.getResourceID(), "resourceID")) break block29;
                                                                        return false;
                                                                    }
                                                                    if (this.checkNotNull(createdDas.getParentID(), "parentID")) break block30;
                                                                    return false;
                                                                }
                                                                if (this.checkNotEmpty(createdDas.getParentID(), "parentID")) break block31;
                                                                return false;
                                                            }
                                                            if (this.checkNull(createdDas.getExpirationTime(), "expirationTime")) break block32;
                                                            return false;
                                                        }
                                                        if (this.checkNotNull(createdDas.getAccessControlPolicyIDs(), "accessControlPolicyIDs")) break block33;
                                                        return false;
                                                    }
                                                    if (createdDas.getAccessControlPolicyIDs().size() == 0) {
                                                        this.setState(Test.State.KO);
                                                        this.setMessage("expected at least one default ACP");
                                                    }
                                                    if (this.checkNotNull(createdDas.getCreationTime(), "creationTime")) break block34;
                                                    return false;
                                                }
                                                if (this.checkNotEmpty(createdDas.getCreationTime(), "creatiomTime")) break block35;
                                                return false;
                                            }
                                            if (this.checkNotNull(createdDas.getLastModifiedTime(), "lastModifiedTime")) break block36;
                                            return false;
                                        }
                                        if (this.checkNotEmpty(createdDas.getLastModifiedTime(), "lastModifiedTime")) break block37;
                                        return false;
                                    }
                                    if (this.checkNotNull(createdDas.getLabels(), "labels")) break block38;
                                    return false;
                                }
                                if (createdDas.getLabels().size() == 0) break block39;
                                this.setState(Test.State.KO);
                                this.setMessage("no label expected, found " + createdDas.getLabels().toString());
                                return false;
                            }
                            if (this.checkNotNull(createdDas.getDynamicAuthorizationEnabled(), "dynamicAuthorizationEnabled")) break block40;
                            return false;
                        }
                        if (this.checkEquals(createdDas.getDynamicAuthorizationEnabled(), enabled, "dynamicAuthorizationEnabled")) break block41;
                        return false;
                    }
                    if (this.checkEquals(createdDas.getDynamicAuthorisationPoA(), poa, "dynamicAuthorizationPoA")) break block42;
                    return false;
                }
                return this.checkNotNull(createdDas.getDynamicAuthorizationLifetime(), "dynamicAuthorizationLifetime");
            }
            this.setState(Test.State.KO);
            this.setMessage("unexpected " + response.getResponseStatusCode() + " response status code. Expected " + ResponseStatusCode.CREATED);
            return false;
        }
        this.setState(Test.State.KO);
        this.setMessage("response is null");
        return false;
    }
}

