/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import java.util.ArrayList;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.datamapping.service.DataMapperService;
import org.eclipse.om2m.testsuite.flexcontainer.AccessControlPolicyTest;
import org.eclipse.om2m.testsuite.flexcontainer.AlarmSpeakerFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.BinarySwitchFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.CallbackTest;
import org.eclipse.om2m.testsuite.flexcontainer.EnergyConsumptionFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.FaultDetectionFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.FloodDetectorFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.GasValveFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.LightDeviceFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.LocationFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.RunModeFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.SmartElectricMeterFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.SmokeDetectorFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.SubscriptionTest;
import org.eclipse.om2m.testsuite.flexcontainer.WarningDeviceFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.WaterSensorFlexContainerTest;
import org.eclipse.om2m.testsuite.flexcontainer.WaterValveFlexContainerTest;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private ServiceTracker<CseService, CseService> cseServiceTracker;
    private ServiceTracker<HttpService, HttpService> httpServiceTracker;
    private ServiceTracker<DataMapperService, DataMapperService> dataMapperServiceTracker;
    private CseService currentCseService;
    private HttpService currentHttpService;
    private DataMapperService currentDataMapperService;
    private BundleContext bundleContext;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.httpServiceTracker = new ServiceTracker(this.bundleContext, HttpService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<HttpService, HttpService>(){

            public HttpService addingService(ServiceReference<HttpService> arg0) {
                if (Activator.this.currentHttpService == null) {
                    Activator.this.currentHttpService = (HttpService)Activator.this.bundleContext.getService(arg0);
                    return Activator.this.currentHttpService;
                }
                return null;
            }

            public void modifiedService(ServiceReference<HttpService> arg0, HttpService arg1) {
            }

            public void removedService(ServiceReference<HttpService> arg0, HttpService arg1) {
            }
        });
        this.httpServiceTracker.open();
        this.dataMapperServiceTracker = new ServiceTracker(this.bundleContext, DataMapperService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<DataMapperService, DataMapperService>(){

            public DataMapperService addingService(ServiceReference<DataMapperService> arg0) {
                if (Activator.this.currentDataMapperService == null) {
                    Activator.this.currentDataMapperService = (DataMapperService)Activator.this.bundleContext.getService(arg0);
                    return Activator.this.currentDataMapperService;
                }
                return null;
            }

            public void modifiedService(ServiceReference<DataMapperService> arg0, DataMapperService arg1) {
            }

            public void removedService(ServiceReference<DataMapperService> arg0, DataMapperService arg1) {
            }
        });
        this.dataMapperServiceTracker.open();
        this.cseServiceTracker = new ServiceTracker(context, CseService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<CseService, CseService>(){

            public CseService addingService(ServiceReference<CseService> arg0) {
                if (Activator.this.currentCseService == null) {
                    CseService cseService = (CseService)Activator.this.bundleContext.getService(arg0);
                    Activator.this.setCseServiceAndStartTesting(cseService);
                    return cseService;
                }
                return null;
            }

            public void modifiedService(ServiceReference<CseService> arg0, CseService arg1) {
            }

            public void removedService(ServiceReference<CseService> arg0, CseService arg1) {
                Activator.this.unsetCseServiceAndStopTesting();
            }
        });
        this.cseServiceTracker.open();
    }

    public void stop(BundleContext arg0) throws Exception {
        this.cseServiceTracker.close();
        this.cseServiceTracker = null;
    }

    private void setCseServiceAndStartTesting(CseService cseService) {
        ArrayList<FlexContainerTestSuite> tests = new ArrayList<FlexContainerTestSuite>();
        this.currentCseService = cseService;
        try {
            BinarySwitchFlexContainerTest test1 = new BinarySwitchFlexContainerTest(this.currentCseService);
            test1.executeTestsAndPrintReports();
            tests.add(test1);
            LocationFlexContainerTest test2 = new LocationFlexContainerTest(this.currentCseService);
            test2.executeTestsAndPrintReports();
            tests.add(test2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.currentHttpService != null && this.dataMapperServiceTracker != null) {
            SubscriptionTest subscriptionTest = new SubscriptionTest(cseService, this.currentHttpService, this.currentDataMapperService);
            subscriptionTest.executeTestsAndPrintReports();
        }
        AccessControlPolicyTest acpTest = new AccessControlPolicyTest(this.currentCseService);
        acpTest.executeTestsAndPrintReports();
        tests.add(acpTest);
        FaultDetectionFlexContainerTest faultDetectionTest = new FaultDetectionFlexContainerTest(this.currentCseService);
        faultDetectionTest.executeTestsAndPrintReports();
        tests.add(faultDetectionTest);
        RunModeFlexContainerTest runModeTest = new RunModeFlexContainerTest(cseService);
        runModeTest.executeTestsAndPrintReports();
        tests.add(runModeTest);
        EnergyConsumptionFlexContainerTest energyConsumptionTest = new EnergyConsumptionFlexContainerTest(this.currentCseService);
        energyConsumptionTest.executeTestsAndPrintReports();
        tests.add(energyConsumptionTest);
        WaterSensorFlexContainerTest waterSensorTest = new WaterSensorFlexContainerTest(this.currentCseService);
        waterSensorTest.executeTestsAndPrintReports();
        tests.add(waterSensorTest);
        AlarmSpeakerFlexContainerTest alarmSpeakerTest = new AlarmSpeakerFlexContainerTest(this.currentCseService);
        alarmSpeakerTest.executeTestsAndPrintReports();
        tests.add(alarmSpeakerTest);
        LightDeviceFlexContainerTest lightDeviceTest = new LightDeviceFlexContainerTest(this.currentCseService);
        lightDeviceTest.executeTestsAndPrintReports();
        tests.add(lightDeviceTest);
        SmartElectricMeterFlexContainerTest smartElectricMeterTest = new SmartElectricMeterFlexContainerTest(this.currentCseService);
        smartElectricMeterTest.executeTestsAndPrintReports();
        tests.add(smartElectricMeterTest);
        FloodDetectorFlexContainerTest floodDetectorTest = new FloodDetectorFlexContainerTest(this.currentCseService);
        floodDetectorTest.executeTestsAndPrintReports();
        tests.add(floodDetectorTest);
        GasValveFlexContainerTest gasValveTest = new GasValveFlexContainerTest(this.currentCseService);
        gasValveTest.executeTestsAndPrintReports();
        tests.add(gasValveTest);
        WarningDeviceFlexContainerTest warningDeviceTest = new WarningDeviceFlexContainerTest(this.currentCseService);
        warningDeviceTest.executeTestsAndPrintReports();
        tests.add(warningDeviceTest);
        SmokeDetectorFlexContainerTest smokeDetectorTest = new SmokeDetectorFlexContainerTest(this.currentCseService);
        smokeDetectorTest.executeTestsAndPrintReports();
        tests.add(smokeDetectorTest);
        WaterValveFlexContainerTest waterValveTest = new WaterValveFlexContainerTest(this.currentCseService);
        waterValveTest.executeTestsAndPrintReports();
        tests.add(waterValveTest);
        CallbackTest callbackTest = new CallbackTest(this.currentCseService, this.bundleContext);
        callbackTest.executeTestsAndPrintReports();
        tests.add(callbackTest);
        System.out.println("");
        System.out.println("#####################################################################################");
        for (FlexContainerTestSuite test : tests) {
            test.printTestReports();
        }
    }

    private void unsetCseServiceAndStopTesting() {
        this.currentCseService = null;
    }
}

