/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64InputStream;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.StringUtil;

public final class JSONUtil {
    private static final boolean DEBUG = Boolean.getBoolean(String.valueOf(JSONUtil.class.getName()) + ".debug");

    private JSONUtil() {
    }

    public static void dump(Object value) {
        JSONDumper dumper = new JSONDumper(System.out);
        dumper.dumpValue(value);
        System.out.println();
    }

    public static InputStream build(Object value) {
        JSONBuilder builder = new JSONBuilder();
        InputStream result = builder.buildValue(value);
        if (DEBUG) {
            result = new DebugInputStream(result, "ENCODE ");
        }
        return result;
    }

    public static <T> T parse(InputStream in, String streamKey) throws IOException {
        if (DEBUG) {
            System.out.print("DECODE ");
        }
        JSONParser parser = new JSONParser(in, streamKey);
        Object value = parser.parseValue();
        return (T)value;
    }

    private static final class DebugInputStream
    extends FilterInputStream {
        private final String prefix;
        private boolean prefixDumped;

        public DebugInputStream(InputStream in, String prefix) {
            super(in);
            this.prefix = prefix;
        }

        @Override
        public int read() throws IOException {
            int c = super.read();
            if (c != -1) {
                this.dump(new byte[]{(byte)c}, 0, 1);
            }
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = super.read(b, off, len);
            this.dump(b, off, n);
            return n;
        }

        @Override
        public void close() throws IOException {
            System.out.println();
            super.close();
        }

        private void dump(byte[] b, int off, int len) {
            if (!this.prefixDumped) {
                if (this.prefix != null) {
                    System.out.print(this.prefix);
                }
                this.prefixDumped = true;
            }
            if (len > 0) {
                int i = off;
                while (i < len) {
                    byte c = b[i];
                    System.out.print((char)c);
                    ++i;
                }
            }
        }
    }

    private static final class JSONBuilder {
        public InputStream buildValue(Object value) {
            if (value == null) {
                return IOUtil.streamUTF("null");
            }
            if (value == Boolean.TRUE) {
                return IOUtil.streamUTF("true");
            }
            if (value == Boolean.FALSE) {
                return IOUtil.streamUTF("false");
            }
            if (value.getClass() == Integer.class) {
                return IOUtil.streamUTF(Integer.toString((Integer)value));
            }
            if (value.getClass() == String.class) {
                return IOUtil.streamUTF("\"" + JSONBuilder.escape((String)value) + "\"");
            }
            if (value instanceof Map) {
                Map object = (Map)value;
                return this.buildObject(object);
            }
            if (value instanceof List) {
                List array = (List)value;
                return this.buildArray(array);
            }
            if (value instanceof InputStream) {
                return this.buildStream((InputStream)value);
            }
            throw new IllegalArgumentException("Invalid value: " + value);
        }

        public InputStream buildObject(Map<String, Object> object) {
            Vector<InputStream> streams = new Vector<InputStream>(2 * object.size() + 1);
            streams.add(IOUtil.streamUTF("{"));
            for (Map.Entry<String, Object> entry : object.entrySet()) {
                if (streams.size() > 1) {
                    streams.add(IOUtil.streamUTF(","));
                }
                streams.add(IOUtil.streamUTF("\"" + entry.getKey() + "\":"));
                streams.add(this.buildValue(entry.getValue()));
            }
            streams.add(IOUtil.streamUTF("}"));
            return new SequenceInputStream(streams.elements());
        }

        public InputStream buildArray(List<Object> array) {
            Vector<InputStream> streams = new Vector<InputStream>(2 * array.size() + 1);
            streams.add(IOUtil.streamUTF("["));
            for (Object value : array) {
                if (streams.size() > 1) {
                    streams.add(IOUtil.streamUTF(","));
                }
                streams.add(this.buildValue(value));
            }
            streams.add(IOUtil.streamUTF("]"));
            return new SequenceInputStream(streams.elements());
        }

        public InputStream buildStream(InputStream stream) {
            Vector<InputStream> streams = new Vector<InputStream>(3);
            streams.add(IOUtil.streamUTF("\""));
            streams.add((InputStream)new Base64InputStream(stream, true, Integer.MAX_VALUE, null));
            streams.add(IOUtil.streamUTF("\""));
            return new SequenceInputStream(streams.elements());
        }

        private static String escape(String str) {
            if (str == null) {
                return null;
            }
            int len = str.length();
            StringBuilder builder = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                char c = str.charAt(i);
                if (c > '\u0fff') {
                    builder.append("\\u" + StringUtil.charToHex(c));
                } else if (c > '\u00ff') {
                    builder.append("\\u0" + StringUtil.charToHex(c));
                } else if (c > '\u007f') {
                    builder.append("\\u00" + StringUtil.charToHex(c));
                } else if (c < ' ') {
                    switch (c) {
                        case '\r': {
                            builder.append('\\');
                            builder.append('r');
                            break;
                        }
                        case '\n': {
                            builder.append('\\');
                            builder.append('n');
                            break;
                        }
                        case '\t': {
                            builder.append('\\');
                            builder.append('t');
                            break;
                        }
                        case '\f': {
                            builder.append('\\');
                            builder.append('f');
                            break;
                        }
                        case '\b': {
                            builder.append('\\');
                            builder.append('b');
                            break;
                        }
                        default: {
                            if (c > '\u000f') {
                                builder.append("\\u00" + StringUtil.charToHex(c));
                                break;
                            }
                            builder.append("\\u000" + StringUtil.charToHex(c));
                            break;
                        }
                    }
                } else if (c == '\\') {
                    builder.append('\\');
                    builder.append('\\');
                } else if (c == '\"') {
                    builder.append('\\');
                    builder.append('\"');
                } else {
                    builder.append(c);
                }
                ++i;
            }
            return builder.toString();
        }
    }

    private static final class JSONDumper {
        private final PrintStream out;
        private int level;

        public JSONDumper(PrintStream out) {
            this.out = out;
        }

        public void dumpValue(Object value) {
            if (value instanceof Map) {
                Map object = (Map)value;
                this.dumpObject(object);
            } else if (value instanceof List) {
                List array = (List)value;
                this.dumpArray(array);
            } else if (value instanceof InputStream) {
                InputStream stream = (InputStream)value;
                this.dumpStream(stream);
            } else if (value instanceof String) {
                this.out.print("\"" + value + "\"");
            } else {
                this.out.print(String.valueOf(value));
            }
        }

        public void dumpObject(Map<String, Object> object) {
            this.indent();
            this.out.println("{");
            ++this.level;
            int i = 0;
            for (Map.Entry<String, Object> entry : object.entrySet()) {
                this.indent();
                this.out.print(entry.getKey());
                this.out.print(" : ");
                this.dumpValue(entry.getValue());
                if (++i == object.size()) {
                    this.out.println();
                    continue;
                }
                this.out.println(",");
            }
            --this.level;
            this.indent();
            this.out.print("}");
        }

        public void dumpArray(List<Object> array) {
            this.out.println("[");
            ++this.level;
            int i = 0;
            for (Object value : array) {
                this.dumpValue(value);
                if (++i == array.size()) {
                    this.out.println();
                    continue;
                }
                this.out.println(",");
            }
            --this.level;
            this.indent();
            this.out.print("]");
        }

        public void dumpStream(InputStream stream) {
            this.out.print("STREAM");
        }

        private void indent() {
            int i = 0;
            while (i < this.level) {
                this.out.print("  ");
                ++i;
            }
        }
    }

    public static final class JSONParseException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public JSONParseException(String message) {
            super(message);
        }
    }

    private static final class JSONParser {
        private static final char[] VALUE_CHARS = new char[]{'\"', '-', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '{', '[', 'n', 't', 'f'};
        private static final char[] NUMBER_CHARS = new char[]{'-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', 'e', 'E'};
        private static final char[] CONTROL_CHARS = new char[]{'\"', '\\', '/', 'b', 'f', 'n', 'r', 't', 'u'};
        private final String streamKey;
        private boolean streamAdded;
        private Reader reader;
        private int lookAhead = -1;
        private int pos;

        public JSONParser(InputStream in, String streamKey) {
            this.streamKey = streamKey;
            try {
                this.reader = new InputStreamReader(in, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }

        public Object parseValue() throws IOException {
            char c = this.skipWhitespace();
            if (c == '\"') {
                return this.parseString(true);
            }
            if (c == '-' || c >= '0' && c <= '9') {
                return this.parseNumber(c);
            }
            if (c == '{') {
                return this.parseObject();
            }
            if (c == '[') {
                return this.parseArray();
            }
            if (c == 'n') {
                this.expectChar(this.readChar(), 'u');
                this.expectChar(this.readChar(), 'l');
                this.expectChar(this.readChar(), 'l');
                return null;
            }
            if (c == 't') {
                this.expectChar(this.readChar(), 'r');
                this.expectChar(this.readChar(), 'u');
                this.expectChar(this.readChar(), 'e');
                return true;
            }
            if (c == 'f') {
                this.expectChar(this.readChar(), 'a');
                this.expectChar(this.readChar(), 'l');
                this.expectChar(this.readChar(), 's');
                this.expectChar(this.readChar(), 'e');
                return false;
            }
            this.expectChar(c, VALUE_CHARS);
            return null;
        }

        public String parseString(boolean unescape) throws IOException {
            StringBuilder builder = new StringBuilder();
            char c = this.readChar();
            while (c != '\"') {
                if (unescape && c == '\\') {
                    c = this.readChar();
                    switch (c) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            builder.append(c);
                            break;
                        }
                        case 'b': {
                            builder.append('\b');
                            break;
                        }
                        case 'f': {
                            builder.append('\f');
                            break;
                        }
                        case 'n': {
                            builder.append('\n');
                            break;
                        }
                        case 'r': {
                            builder.append('\r');
                            break;
                        }
                        case 't': {
                            builder.append('\t');
                            break;
                        }
                        case 'u': {
                            StringBuilder unicodeBuilder = new StringBuilder();
                            unicodeBuilder.append(this.readChar());
                            unicodeBuilder.append(this.readChar());
                            unicodeBuilder.append(this.readChar());
                            unicodeBuilder.append(this.readChar());
                            String unicode = unicodeBuilder.toString();
                            try {
                                builder.append(StringUtil.hexToChar(unicode));
                            }
                            catch (NumberFormatException numberFormatException) {
                                builder.append('\\');
                                builder.append('u');
                                builder.append(unicode);
                            }
                            break;
                        }
                        default: {
                            this.expectChar(c, CONTROL_CHARS);
                        }
                    }
                }
                builder.append(c);
                c = this.readChar();
            }
            return builder.toString();
        }

        public Object parseNumber(char c) throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append(c);
            while (JSONParser.isNumberChar(c = this.readChar())) {
                builder.append(c);
            }
            this.rememberChar(c);
            return Integer.parseInt(builder.toString());
        }

        public Map<String, Object> parseObject() throws IOException {
            LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
            while (true) {
                char c;
                if ((c = this.skipWhitespace()) == '}') {
                    return object;
                }
                if (c == ',') {
                    c = this.skipWhitespace();
                }
                if (c != '\"') continue;
                String key = this.parseString(false);
                c = this.skipWhitespace();
                this.expectChar(c, ':');
                if (key.equals(this.streamKey)) {
                    c = this.skipWhitespace();
                    this.expectChar(c, '\"');
                    Base64InputStream stream = new Base64InputStream((InputStream)new ValueInputStream());
                    object.put(key, stream);
                    this.streamAdded = true;
                    return object;
                }
                Object value = this.parseValue();
                object.put(key, value);
                if (this.streamAdded) break;
            }
            return object;
        }

        public List<Object> parseArray() throws IOException {
            ArrayList<Object> array = new ArrayList<Object>();
            do {
                char c;
                if ((c = this.skipWhitespace()) == ']') {
                    return array;
                }
                if (c != ',') {
                    this.rememberChar(c);
                }
                Object value = this.parseValue();
                array.add(value);
            } while (!this.streamAdded);
            return array;
        }

        private char readChar() throws IOException {
            ++this.pos;
            int i = this.lookAhead;
            if (i == -1) {
                i = this.reader.read();
            } else {
                this.lookAhead = -1;
            }
            if (i == -1) {
                throw new EOFException();
            }
            char c = (char)i;
            if (DEBUG) {
                System.out.print(c);
            }
            return c;
        }

        private void rememberChar(char c) {
            this.lookAhead = c;
            --this.pos;
        }

        private void expectChar(char c, char ... expectedChars) throws IOException {
            int i = 0;
            while (i < expectedChars.length) {
                char expectedChar = expectedChars[i];
                if (c == expectedChar) {
                    return;
                }
                ++i;
            }
            StringBuilder builder = new StringBuilder();
            int i2 = 0;
            while (i2 < expectedChars.length) {
                if (builder.length() != 0) {
                    builder.append(" or ");
                }
                builder.append("'");
                builder.append(expectedChars[i2]);
                builder.append("'");
                ++i2;
            }
            throw new JSONParseException("Expected " + builder + " but found '" + c + "' at position " + this.pos);
        }

        private char skipWhitespace() throws IOException {
            char c = this.readChar();
            while (Character.isWhitespace(c)) {
                c = this.readChar();
            }
            return c;
        }

        private static boolean isNumberChar(char c) {
            int i = 0;
            while (i < NUMBER_CHARS.length) {
                char numberChar = NUMBER_CHARS[i];
                if (c == numberChar) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private final class ValueInputStream
        extends InputStream {
            private boolean eof;

            private ValueInputStream() {
            }

            @Override
            public int read() throws IOException {
                if (this.eof) {
                    return -1;
                }
                int c = JSONParser.this.reader.read();
                if (DEBUG && c != -1) {
                    System.out.print((char)c);
                }
                if (c == 34) {
                    this.eof = true;
                    return -1;
                }
                return c;
            }

            @Override
            public void close() throws IOException {
                if (DEBUG) {
                    System.out.println("}");
                }
                JSONParser.this.reader.close();
                super.close();
            }
        }
    }
}

