/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.synchronizer;

import com.sun.messaging.jmq.util.LoggerWrapper;
import com.sun.messaging.jmq.util.synchronizer.CloseInProgressCallback;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloseInProgressSynchronizer {
    private static final long WAIT_INTERVAL = 15000L;
    private boolean closed = false;
    private Object closedLock = new Object();
    private int inprogressCount = 0;
    private Object inprogressLock = new Object();
    private Object logger = null;

    public CloseInProgressSynchronizer(Object logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = false;
            this.closedLock.notifyAll();
        }
        object = this.inprogressLock;
        synchronized (object) {
            this.inprogressCount = 0;
            this.inprogressLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosedAndWait(CloseInProgressCallback cb, String waitlogmsg) {
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
        }
        if (cb != null) {
            cb.beforeWaitAfterSetClosed();
        }
        object = this.inprogressLock;
        synchronized (object) {
            long currtime;
            this.inprogressLock.notifyAll();
            if (this.inprogressCount == 0) {
                return;
            }
            this.logInfo(waitlogmsg);
            long lastlogtime = currtime = System.currentTimeMillis();
            while (this.inprogressCount > 0) {
                try {
                    if (currtime - lastlogtime >= 15000L) {
                        this.logInfo(waitlogmsg);
                        lastlogtime = currtime;
                    }
                    this.inprogressLock.wait(15000L);
                    if (this.inprogressCount <= 0) continue;
                    currtime = System.currentTimeMillis();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosedAndWaitWithTimeout(CloseInProgressCallback cb, int timeout, String waitlogmsg) throws InterruptedException, TimeoutException {
        long maxwait;
        if (timeout <= 0) {
            this.setClosedAndWait(cb, waitlogmsg);
            return;
        }
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
        }
        if (cb != null) {
            cb.beforeWaitAfterSetClosed();
        }
        long waittime = maxwait = (long)timeout * 1000L;
        Object object2 = this.inprogressLock;
        synchronized (object2) {
            long currtime;
            this.inprogressLock.notifyAll();
            if (this.inprogressCount == 0) {
                return;
            }
            this.logInfo(waitlogmsg);
            long precurrtime = currtime = System.currentTimeMillis();
            long lastlogtime = 0L;
            long totalwaited = 0L;
            while (this.inprogressCount > 0 && waittime > 0L) {
                if (currtime - lastlogtime > 15000L) {
                    this.logInfo(waitlogmsg);
                    lastlogtime = currtime;
                }
                this.inprogressLock.wait(waittime);
                precurrtime = currtime;
                currtime = System.currentTimeMillis();
                totalwaited += currtime - precurrtime > 0L ? currtime - precurrtime : 0L;
                if (this.inprogressCount <= 0) continue;
                waittime = maxwait - totalwaited;
            }
            if (this.inprogressCount > 0) {
                throw new TimeoutException("timeout");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClosedAndSetInProgress() throws IllegalAccessException {
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalAccessException("closed");
            }
            this.setInProgress(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInProgress(boolean flag) {
        Object object = this.inprogressLock;
        synchronized (object) {
            this.inprogressCount = flag ? ++this.inprogressCount : --this.inprogressCount;
            if (this.inprogressCount == 0) {
                this.inprogressLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClosedAndSetInProgressWithWait(int timeout, String waitlogmsg) throws InterruptedException, TimeoutException {
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            this.setInProgressWithWait(timeout, waitlogmsg);
        }
    }

    private void setInProgressWithWait(int timeout, String waitlogmsg) throws InterruptedException, TimeoutException {
        Object object = this.inprogressLock;
        synchronized (object) {
            long currtime;
            if (this.inprogressCount == 0) {
                ++this.inprogressCount;
                return;
            }
            long maxwait = (long)timeout * 1000L;
            long waittime = maxwait <= 0L || maxwait > 15000L ? 15000L : maxwait;
            this.logInfo(waitlogmsg);
            long precurrtime = currtime = System.currentTimeMillis();
            long lastlogtime = 0L;
            long totalwaited = 0L;
            while (this.inprogressCount > 0 && !this.closed && waittime > 0L) {
                if (currtime - lastlogtime > 15000L) {
                    this.logInfo(waitlogmsg);
                    lastlogtime = currtime;
                }
                this.inprogressLock.wait(waittime);
                precurrtime = currtime;
                currtime = System.currentTimeMillis();
                totalwaited += currtime - precurrtime > 0L ? currtime - precurrtime : 0L;
                if (this.inprogressCount > 0) {
                    long l = waittime = maxwait <= 0L ? 15000L : maxwait - totalwaited;
                }
                if (waittime <= 15000L) continue;
                waittime = 15000L;
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.inprogressCount == 0) {
                ++this.inprogressCount;
                return;
            }
            throw new TimeoutException("timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closedLock;
        synchronized (object) {
            return this.closed;
        }
    }

    private void logInfo(String msg) {
        if (this.logger instanceof LoggerWrapper) {
            ((LoggerWrapper)this.logger).logInfo(msg, null);
        } else if (this.logger instanceof Logger) {
            ((Logger)this.logger).log(Level.INFO, msg);
        } else {
            System.out.println("INFO: " + msg);
        }
    }
}

