/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMetaStoreUserPropertyCache {
    Logger logger = LoggerFactory.getLogger(SimpleMetaStoreUserPropertyCache.class);
    private Map<String, Map<String, String>> cacheMap = new ConcurrentHashMap<String, Map<String, String>>();

    public void register(List<String> propertyKeys) throws CoreException {
        for (String propertyKey : propertyKeys) {
            if (this.cacheMap.containsKey(propertyKey)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStoreUserPropertyCache.registerUserProperty: property " + propertyKey + " is already registered", null));
            }
            ConcurrentHashMap cache = new ConcurrentHashMap();
            this.cacheMap.put(propertyKey, cache);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Created user cache for the " + propertyKey + " property");
        }
    }

    public boolean isRegistered(String propertyKey) {
        return this.cacheMap.containsKey(propertyKey);
    }

    public void add(String propertyKey, String value, String userId) {
        Map<String, String> cache = this.cacheMap.get(propertyKey);
        if (cache == null) {
            return;
        }
        if (cache.containsValue(userId)) {
            String key = null;
            for (Map.Entry<String, String> entry : cache.entrySet()) {
                if (!userId.equals(entry.getValue())) continue;
                key = entry.getKey();
            }
            if (key != null) {
                cache.remove(key);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Removed " + key + " for the user " + userId + " from the user cache for the " + propertyKey + " property");
                }
            }
        }
        cache.put(value, userId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added " + value + " for the user " + userId + " to the user cache for the " + propertyKey + " property");
        }
    }

    public void deleteUser(String userId) {
        for (String propertyKey : this.cacheMap.keySet()) {
            Map<String, String> cache = this.cacheMap.get(propertyKey);
            if (!cache.containsValue(userId)) continue;
            String key = null;
            for (Map.Entry<String, String> entry : cache.entrySet()) {
                if (!userId.equals(entry.getValue())) continue;
                key = entry.getKey();
            }
            if (key == null) continue;
            cache.remove(key);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Removed " + key + " for the user " + userId + " from the user cache for the " + propertyKey + " property");
        }
    }

    public void addUsers(List<String> userIds) {
        if (this.cacheMap.containsKey("UserName")) {
            Map<String, String> cache = this.cacheMap.get("UserName");
            for (String userId : userIds) {
                cache.put(userId, userId);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Added " + userId + " to the user cache for the " + "UserName" + " property");
            }
        }
    }

    public String readUserByProperty(String key, String value, boolean regExp, boolean ignoreCase) throws CoreException {
        if (!this.cacheMap.containsKey(key)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.registerUserProperty: property " + key + " is not registered", null));
        }
        Map<String, String> cache = this.cacheMap.get(key);
        Pattern pattern = regExp ? Pattern.compile(value, 40) : null;
        for (Map.Entry<String, String> entry : cache.entrySet()) {
            boolean hasMatch;
            String cacheKey = entry.getKey();
            String userId = entry.getValue();
            if (pattern != null) {
                hasMatch = pattern.matcher(cacheKey).matches();
            } else {
                boolean bl = hasMatch = ignoreCase ? cacheKey.equalsIgnoreCase(value) : cacheKey.equals(value);
            }
            if (!hasMatch) continue;
            return userId;
        }
        return null;
    }

    public void setProperties(String userId, Map<String, String> properties) {
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            if (!this.cacheMap.containsKey(key)) continue;
            Map<String, String> cache = this.cacheMap.get(key);
            if (cache.containsValue(userId)) {
                String oldValue = null;
                for (Map.Entry<String, String> entry : cache.entrySet()) {
                    if (!userId.equals(entry.getValue())) continue;
                    oldValue = entry.getKey();
                }
                if (oldValue != null) {
                    cache.remove(oldValue);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Removed " + oldValue + " for the user " + userId + " to the user cache for the " + key + " property");
                    }
                }
            }
            cache.put(value, userId);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Added " + value + " for the user " + userId + " to the user cache for the " + key + " property");
        }
    }

    public void delete(String key, String value, String userId) {
        Map<String, String> cache = this.cacheMap.get(key);
        cache.remove(value);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Deleted " + value + " for the user " + userId + " from the user cache for the " + key + " property");
        }
    }
}

