// This is a generated file, modify: generate/templates/class_content.cc

#include <nan.h>
#include <string.h>

extern "C" {
#include <git2.h>
}

#include "../include/nodegit.h"
#include "../include/lock_master.h"
#include "../include/functions/copy.h"
#include "../include/tree_entry.h"
#include "nodegit_wrapper.cc"
#include "../include/async_libgit2_queue_worker.h"

#include "../include/oid.h"
#include "../include/object.h"
#include "../include/repository.h"

#include <iostream>

using namespace std;
using namespace v8;
using namespace node;

GitTreeEntry::~GitTreeEntry()
{
  // this will cause an error if you have a non-self-freeing object that also needs
  // to save values. Since the object that will eventually free the object has no
  // way of knowing to free these values.
}

void GitTreeEntry::InitializeComponent(Local<v8::Object> target)
{
  Nan::HandleScope scope;

  Local<FunctionTemplate> tpl = Nan::New<FunctionTemplate>(JSNewFunction);

  tpl->InstanceTemplate()->SetInternalFieldCount(1);
  tpl->SetClassName(Nan::New("TreeEntry").ToLocalChecked());

  Nan::SetPrototypeMethod(tpl, "filemode", Filemode);
  Nan::SetPrototypeMethod(tpl, "filemodeRaw", FilemodeRaw);
  Nan::SetPrototypeMethod(tpl, "free", Free);
  Nan::SetPrototypeMethod(tpl, "id", Id);
  Nan::SetPrototypeMethod(tpl, "name", Name);
  Nan::SetPrototypeMethod(tpl, "toObject", ToObject);
  Nan::SetPrototypeMethod(tpl, "type", Type);

  InitializeTemplate(tpl);

  Local<Function> _constructor_template = Nan::GetFunction(tpl).ToLocalChecked();
  constructor_template.Reset(_constructor_template);
  Nan::Set(target, Nan::New("TreeEntry").ToLocalChecked(), _constructor_template);
}


/*
     * @return Number  result    */
NAN_METHOD(GitTreeEntry::Filemode)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                         );

    git_filemode_t result = git_tree_entry_filemode(
                              Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                            );


    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     * @return Number  result    */
NAN_METHOD(GitTreeEntry::FilemodeRaw)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                         );

    git_filemode_t result = git_tree_entry_filemode_raw(
                              Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                            );


    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     */
NAN_METHOD(GitTreeEntry::Free)
{
  Nan::EscapableHandleScope scope;

  if (Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue() != NULL) {

    giterr_clear();

    {
      LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                           );

      git_tree_entry_free(
        Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
      );

      Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->ClearValue();
    }
    return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
  }
}

/*
     * @return Oid  result    */
NAN_METHOD(GitTreeEntry::Id)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                         );

    const git_oid * result = git_tree_entry_id(
                               Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                             );

    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    Local<v8::Value> to;
// start convert_to_v8 block

    if (result != NULL) {
      // GitOid result
      to = GitOid::New(result, true , info.This() );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     * @return String  result    */
NAN_METHOD(GitTreeEntry::Name)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                         );

    const char * result = git_tree_entry_name(
                            Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                          );

    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    Local<v8::Value> to;
// start convert_to_v8 block
    if (result) {
      to = Nan::New<String>(result).ToLocalChecked();
    } else {
      to = Nan::Null();
    }

    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
 * @param Object object_out
   * @param Repository repo
       * @return Number  result    */
NAN_METHOD(GitTreeEntry::ToObject)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsObject()) {
    return Nan::ThrowError("Object object_out is required.");
  }

  if (info.Length() == 1 || !info[1]->IsObject()) {
    return Nan::ThrowError("Repository repo is required.");
  }

// start convert_from_v8 block
  git_object ** from_object_out;
  *from_object_out = Nan::ObjectWrap::Unwrap<GitObject>(info[0]->ToObject())->GetValue();
// end convert_from_v8 block
// start convert_from_v8 block
  git_repository * from_repo;
  from_repo = Nan::ObjectWrap::Unwrap<GitRepository>(info[1]->ToObject())->GetValue();
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    from_object_out
                                           ,    from_repo
                                           ,    Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                         );

    int result = git_tree_entry_to_object(
                   from_object_out
                   ,  from_repo
                   ,  Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                 );


    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     * @return Number  result    */
NAN_METHOD(GitTreeEntry::Type)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                         );

    git_otype result = git_tree_entry_type(
                         Nan::ObjectWrap::Unwrap<GitTreeEntry>(info.This())->GetValue()
                       );


    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}
// force base class template instantiation, to make sure we get all the
// methods, statics, etc.
template class NodeGitWrapper<GitTreeEntryTraits>;
