"use strict";
var loader = require('./loader');
var dumper = require('./dumper');
var YAMLException = (function () {
    function YAMLException(reason, mark) {
        if (mark === void 0) { mark = null; }
        this.name = 'YAMLException';
        this.reason = reason;
        this.mark = mark;
        this.message = this.toString(false);
    }
    YAMLException.prototype.toString = function (compact) {
        if (compact === void 0) { compact = false; }
        var result;
        result = 'JS-YAML: ' + (this.reason || '(unknown reason)');
        if (!compact && this.mark) {
            result += ' ' + this.mark.toString();
        }
        return result;
    };
    return YAMLException;
}());
exports.YAMLException = YAMLException;
(function (Kind) {
    Kind[Kind["SCALAR"] = 0] = "SCALAR";
    Kind[Kind["MAPPING"] = 1] = "MAPPING";
    Kind[Kind["MAP"] = 2] = "MAP";
    Kind[Kind["SEQ"] = 3] = "SEQ";
    Kind[Kind["ANCHOR_REF"] = 4] = "ANCHOR_REF";
    Kind[Kind["INCLUDE_REF"] = 5] = "INCLUDE_REF";
})(exports.Kind || (exports.Kind = {}));
var Kind = exports.Kind;
function newMapping(key, value) {
    var end = (value ? value.endPosition : key.endPosition + 1);
    var node = {
        key: key,
        value: value,
        startPosition: key.startPosition,
        endPosition: end,
        kind: Kind.MAPPING,
        parent: null,
        errors: []
    };
    return node;
}
exports.newMapping = newMapping;
function newAnchorRef(key, start, end, value) {
    return {
        errors: [],
        referencesAnchor: key,
        value: value,
        startPosition: start,
        endPosition: end,
        kind: Kind.ANCHOR_REF,
        parent: null
    };
}
exports.newAnchorRef = newAnchorRef;
function newScalar(v) {
    if (v === void 0) { v = ""; }
    return {
        errors: [],
        startPosition: -1,
        endPosition: -1,
        value: v,
        kind: Kind.SCALAR,
        parent: null,
        doubleQuoted: false
    };
}
exports.newScalar = newScalar;
function newItems() {
    return {
        errors: [],
        startPosition: -1,
        endPosition: -1,
        items: [],
        kind: Kind.SEQ,
        parent: null
    };
}
exports.newItems = newItems;
function newSeq() {
    return newItems();
}
exports.newSeq = newSeq;
function newMap(mappings) {
    return {
        errors: [],
        startPosition: -1,
        endPosition: -1,
        mappings: mappings ? mappings : [],
        kind: Kind.MAP,
        parent: null
    };
}
exports.newMap = newMap;
function deprecated(name) {
    return function () {
        throw new Error('Function ' + name + ' is deprecated and cannot be used.');
    };
}
exports.load = loader.load;
exports.loadAll = loader.loadAll;
exports.safeLoad = loader.safeLoad;
exports.dump = dumper.dump;
exports.safeDump = dumper.safeDump;
//# sourceMappingURL=index.js.map