/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.testers;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.mylyn.reviews.frame.core.model.Topic;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4ECompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CloneAnomalyPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Iterator iterator;
        R4EUIReviewBasic activeReview = R4EUIModelController.getActiveReview();
        if (activeReview == null) {
            return false;
        }
        if (activeReview.isReadOnly()) {
            return false;
        }
        if (((R4EReviewState)activeReview.getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) {
            return false;
        }
        EList anomalies = activeReview.getReview().getTopics();
        if (anomalies.isEmpty()) {
            return false;
        }
        boolean isLocalAnomalies = false;
        int anomaliesSize = anomalies.size();
        int i = 0;
        while (i < anomaliesSize) {
            if (!((Topic)anomalies.get(i)).getLocation().isEmpty()) {
                isLocalAnomalies = true;
                break;
            }
            ++i;
        }
        if (!isLocalAnomalies) {
            return false;
        }
        if (receiver instanceof AbstractSet && (iterator = ((AbstractSet)receiver).iterator()).next() instanceof TextSelection && !this.isR4EEditorInputAvailable()) {
            return false;
        }
        if (receiver instanceof AbstractList) {
            iterator = ((AbstractList)receiver).iterator();
            if (!iterator.hasNext()) {
                if (!this.isR4EEditorInputAvailable()) {
                    return false;
                }
            } else {
                Object obj = iterator.next();
                if ((R4EUIPlugin.isJDTAvailable() && obj instanceof org.eclipse.jdt.core.ISourceReference || R4EUIPlugin.isCDTAvailable() && obj instanceof ISourceReference) && !this.isR4EEditorInputAvailable()) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isR4EEditorInputAvailable() {
        ITypedElement targetElement;
        IWorkbenchPage page;
        IEditorInput editorInput = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window == null || (page = window.getActivePage()) == null || page.getActiveEditor() == null || !((editorInput = page.getActiveEditor().getEditorInput()) instanceof R4EFileRevisionEditorInput ? ((R4EFileRevisionEditorInput)editorInput).getFileVersion().getRepositoryPath() == null : editorInput instanceof R4ECompareEditorInput && (targetElement = ((R4ECompareEditorInput)editorInput).getLeftElement()) == null);
    }
}

