/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.mylyn.reviews.frame.core.model.CommentType;
import org.eclipse.mylyn.reviews.frame.core.utils.Tracer;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyTextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EComment;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ECommentType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EContent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EContextType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUser;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserRole;
import org.eclipse.mylyn.reviews.r4e.core.model.RModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.IRFSRegistry;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.RFSRegistryFactory;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4ECompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedFile;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.versions.core.ChangeType;
import org.eclipse.mylyn.versions.core.ScmArtifact;
import org.eclipse.mylyn.versions.core.ScmCore;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class CommandUtils {
    private static final String NO_SOURCE_CONTROL_ID_TEXT = "(Version not in Source Control)";
    private static final String INVALID_PATH = "/dev/null";

    public static R4EFileVersion getTargetFileData(IEditorInput aInput) throws CoreException, ReviewsFileStorageException {
        IFile editorFile = null;
        if (aInput instanceof IFileEditorInput) {
            editorFile = ((IFileEditorInput)aInput).getFile();
            if (editorFile == null) {
                return null;
            }
            return CommandUtils.updateTargetFile(editorFile);
        }
        if (aInput instanceof R4ECompareEditorInput) {
            ITypedElement element = ((R4ECompareEditorInput)aInput).getLeftElement();
            if (element instanceof R4EFileRevisionTypedElement) {
                return ((R4EFileRevisionTypedElement)element).getFileVersion();
            }
            if (element instanceof R4EFileTypedElement) {
                return ((R4EFileTypedElement)element).getFileVersion();
            }
            return null;
        }
        if (aInput instanceof R4EFileRevisionEditorInput) {
            return ((R4EFileRevisionEditorInput)aInput).getFileVersion();
        }
        if (aInput instanceof R4EFileEditorInput) {
            return ((R4EFileEditorInput)aInput).getFileVersion();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Invalid input " + (aInput != null ? aInput.getClass().toString() : ""), null));
    }

    public static R4EFileVersion updateTargetFile(IFile aFile) throws CoreException, ReviewsFileStorageException {
        ScmArtifact artifact;
        if (aFile == null) {
            return null;
        }
        String remoteID = null;
        String localID = null;
        IRFSRegistry localRepository = RFSRegistryFactory.getRegistry((R4EReview)R4EUIModelController.getActiveReview().getReview());
        if (localRepository == null) {
            return null;
        }
        ScmConnector connector = ScmCore.getConnector((IResource)aFile.getProject());
        if (connector != null && (artifact = connector.getArtifact((IResource)aFile)) != null && artifact.getPath() != null) {
            IStorage fileStore;
            IFileRevision fileRev = artifact.getFileRevision(null);
            if (fileRev != null && (fileStore = fileRev.getStorage(null)) != null) {
                remoteID = localRepository.blobIdFor(fileStore.getContents());
                localID = localRepository.blobIdFor(aFile.getContents());
                if (remoteID != null && remoteID.equals(localID)) {
                    return CommandUtils.copyRemoteFileToLocalRepository(localRepository, artifact);
                }
            }
            return CommandUtils.copyWorkspaceFileToLocalRepository(localRepository, aFile);
        }
        return CommandUtils.copyWorkspaceFileToLocalRepository(localRepository, aFile);
    }

    public static R4EFileVersion getBaseFileData(IEditorInput aInput) throws CoreException, ReviewsFileStorageException {
        IFile editorFile = null;
        if (aInput instanceof IFileEditorInput) {
            editorFile = ((IFileEditorInput)aInput).getFile();
            return CommandUtils.updateBaseFile(editorFile);
        }
        if (aInput instanceof R4ECompareEditorInput) {
            ITypedElement leftElement = ((R4ECompareEditorInput)aInput).getLeftElement();
            ITypedElement rightElement = ((R4ECompareEditorInput)aInput).getRightElement();
            if (leftElement instanceof R4EFileTypedElement && rightElement instanceof R4EFileRevisionTypedElement) {
                if (((R4EFileTypedElement)leftElement).getFileVersion().getVersionID().equals(NO_SOURCE_CONTROL_ID_TEXT)) {
                    return ((R4EFileRevisionTypedElement)rightElement).getFileVersion();
                }
                return ((R4EFileTypedElement)leftElement).getFileVersion();
            }
            if (leftElement instanceof R4EFileRevisionTypedElement) {
                return ((R4EFileRevisionTypedElement)leftElement).getFileVersion();
            }
            return null;
        }
        if (aInput instanceof R4EFileRevisionEditorInput) {
            return ((R4EFileRevisionEditorInput)aInput).getFileVersion();
        }
        if (aInput instanceof R4EFileEditorInput) {
            return ((R4EFileEditorInput)aInput).getFileVersion();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Invalid input " + (aInput != null ? aInput.getClass().toString() : ""), null));
    }

    public static R4EFileVersion updateBaseFile(IFile aFile) throws CoreException, ReviewsFileStorageException {
        ScmArtifact artifact;
        if (aFile == null) {
            return null;
        }
        ScmConnector connector = ScmCore.getConnector((IResource)aFile.getProject());
        if (connector != null && (artifact = connector.getArtifact((IResource)aFile)) != null && artifact.getId() != null) {
            IRFSRegistry localRepository = RFSRegistryFactory.getRegistry((R4EReview)R4EUIModelController.getActiveReview().getReview());
            return CommandUtils.copyRemoteFileToLocalRepository(localRepository, artifact);
        }
        return null;
    }

    public static R4EFileVersion copyRemoteFileToLocalRepository(IRFSRegistry aLocalRepository, ScmArtifact aArtifact) throws ReviewsFileStorageException, CoreException {
        if (aArtifact == null || aArtifact.getPath() == null || aArtifact.getPath().equals(INVALID_PATH)) {
            return null;
        }
        IFileRevision fileRev = aArtifact.getFileRevision(null);
        if (fileRev == null) {
            return null;
        }
        InputStream iStream = null;
        IStorage fileStore = fileRev.getStorage(null);
        if (fileStore == null) {
            return null;
        }
        try {
            iStream = fileStore.getContents();
        }
        catch (CoreException e) {
            R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            return null;
        }
        R4EFileVersion tmpFileVersion = RModelFactory.eINSTANCE.createR4EFileVersion();
        if (tmpFileVersion != null && aLocalRepository != null) {
            CommandUtils.updateFileVersion(tmpFileVersion, aArtifact);
            tmpFileVersion.setLocalVersionID(aLocalRepository.registerReviewBlob(iStream));
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (IOException e) {
                    R4EUIPlugin.Ftracer.traceWarning("Exception while closing stream, " + e.toString());
                }
            }
        }
        return tmpFileVersion;
    }

    public static R4EFileVersion copyRemoteFileToLocalRepository(ReentrantLock aLock, IRFSRegistry aLocalRepository, ScmArtifact aArtifact, IProgressMonitor aMainMonitor) throws ReviewsFileStorageException, CoreException {
        IFileRevision fileRev;
        ReentrantLock lock = aLock;
        if (lock == null) {
            lock = new ReentrantLock();
        }
        if (aMainMonitor.isCanceled()) {
            throw new CoreException((IStatus)new Status(8, "org.eclipse.mylyn.reviews.r4e.ui", 8, "Operation cancelled by User", null));
        }
        if (aArtifact == null || aArtifact.getPath() == null || aArtifact.getPath().equals(INVALID_PATH)) {
            return null;
        }
        Date fetchStart = null;
        if (Tracer.isInfo()) {
            fetchStart = new Date();
        }
        if ((fileRev = aArtifact.getFileRevision(null)) == null) {
            return null;
        }
        InputStream iStream = null;
        IStorage fileStore = fileRev.getStorage(null);
        if (fileStore == null) {
            return null;
        }
        try {
            iStream = fileStore.getContents();
        }
        catch (CoreException e) {
            R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            return null;
        }
        R4EFileVersion tmpFileVersion = RModelFactory.eINSTANCE.createR4EFileVersion();
        if (tmpFileVersion != null && aLocalRepository != null) {
            CommandUtils.updateFileVersion(tmpFileVersion, aArtifact);
            if (aMainMonitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(8, "org.eclipse.mylyn.reviews.r4e.ui", 8, "Operation cancelled by User", null));
            }
            Date blobRegStart = null;
            if (fetchStart != null) {
                blobRegStart = new Date();
            }
            lock.lock();
            try {
                tmpFileVersion.setLocalVersionID(aLocalRepository.registerReviewBlob(iStream));
            }
            finally {
                lock.unlock();
                if (fetchStart != null) {
                    long downloadTime = blobRegStart.getTime() - fetchStart.getTime();
                    long uploadTime = new Date().getTime() - blobRegStart.getTime();
                    R4EUIPlugin.Ftracer.traceInfo("Registered blob for " + fileRev.getName() + " " + aArtifact.getId() + ", fetch (ms): " + downloadTime + ", push (ms) " + uploadTime);
                }
                if (iStream != null) {
                    try {
                        iStream.close();
                    }
                    catch (IOException e) {
                        R4EUIPlugin.Ftracer.traceWarning("Exception while closing stream, " + e.toString());
                    }
                }
            }
        }
        return tmpFileVersion;
    }

    public static R4EFileVersion copyWorkspaceFileToLocalRepository(IRFSRegistry aLocalRepository, IFile aFile) throws CoreException, ReviewsFileStorageException {
        R4EFileVersion tmpFileVersion = null;
        if (aLocalRepository != null && aFile != null && (tmpFileVersion = RModelFactory.eINSTANCE.createR4EFileVersion()) != null) {
            CommandUtils.updateFileVersion(tmpFileVersion, aFile);
            tmpFileVersion.setLocalVersionID(aLocalRepository.registerReviewBlob(aFile.getContents()));
            tmpFileVersion.setVersionID(NO_SOURCE_CONTROL_ID_TEXT);
        }
        return tmpFileVersion;
    }

    public static R4EUITextPosition getPosition(ITextSelection aSelection) {
        if (aSelection == null) {
            return null;
        }
        return new R4EUITextPosition(aSelection.getOffset(), aSelection.getLength(), aSelection.getStartLine(), aSelection.getEndLine());
    }

    public static R4EUITextPosition getPosition(int aOffset, int aLength, IDocument aDoc) {
        R4EUITextPosition position = new R4EUITextPosition(aOffset, aLength, aDoc);
        return position;
    }

    public static R4EUITextPosition getPosition(IFile aSelectedElement) throws CoreException {
        if (aSelectedElement == null) {
            return null;
        }
        R4EUITextPosition position = new R4EUITextPosition(0, -1, aSelectedElement);
        position.setName(aSelectedElement.getName());
        return position;
    }

    public static R4EUITextPosition getPosition(org.eclipse.jdt.core.ISourceReference aSelectedElement, IFile aFile) throws CoreException {
        int offset = 0;
        int length = 0;
        String name = "";
        if (aSelectedElement != null) {
            ISourceRange sourceRange = aSelectedElement.getSourceRange();
            if (sourceRange != null) {
                offset = sourceRange.getOffset();
                length = sourceRange.getLength();
            }
            name = ((IJavaElement)aSelectedElement).getElementName();
        }
        R4EUITextPosition position = new R4EUITextPosition(offset, length, aFile);
        position.setName(name);
        return position;
    }

    public static R4EUITextPosition getPosition(ISourceReference aSelectedElement, IFile aFile) throws CoreException {
        int startPos = 0;
        int length = 0;
        int startLine = 0;
        int endLine = 0;
        String name = "";
        if (aSelectedElement != null) {
            org.eclipse.cdt.core.model.ISourceRange sourceRange = aSelectedElement.getSourceRange();
            if (sourceRange != null) {
                startPos = sourceRange.getStartPos();
                length = sourceRange.getLength();
                startLine = sourceRange.getStartLine();
                endLine = sourceRange.getEndLine();
            }
            name = ((ICElement)aSelectedElement).getElementName();
        }
        R4EUITextPosition position = new R4EUITextPosition(startPos, length, aFile);
        position.setStartLine(startLine);
        position.setEndLine(endLine);
        position.setName(name);
        return position;
    }

    public static R4EContextType adaptType(ChangeType aChangeType) {
        R4EContextType dtype = null;
        switch (aChangeType) {
            case ADDED: {
                dtype = R4EContextType.R4E_ADDED;
                break;
            }
            case DELETED: {
                dtype = R4EContextType.R4E_DELETED;
                break;
            }
            case MODIFIED: {
                dtype = R4EContextType.R4E_MODIFIED;
                break;
            }
            case REPLACED: {
                dtype = R4EContextType.R4E_REPLACED;
                break;
            }
        }
        return dtype;
    }

    public static void copyFileVersionData(R4EFileVersion aTargetFileVer, R4EFileVersion aSourceFileVer) {
        if (aTargetFileVer != null && aSourceFileVer != null) {
            aTargetFileVer.setName(aSourceFileVer.getName());
            aTargetFileVer.setVersionID(aSourceFileVer.getVersionID());
            aTargetFileVer.setRepositoryPath(aSourceFileVer.getRepositoryPath());
            aTargetFileVer.setLocalVersionID(aSourceFileVer.getLocalVersionID());
            aTargetFileVer.setPlatformURI(aSourceFileVer.getPlatformURI());
            aTargetFileVer.setResource(aSourceFileVer.getResource());
        }
    }

    public static void updateFileVersion(R4EFileVersion aTargetFileVer, ScmArtifact aScmArt) throws CoreException {
        if (aTargetFileVer != null && aScmArt != null) {
            String fileRelPath;
            IPath filePath;
            IStorage fileStore;
            aTargetFileVer.setName(aScmArt.getFileRevision(null).getName());
            aTargetFileVer.setVersionID(aScmArt.getId());
            IFileRevision fileRev = aScmArt.getFileRevision(null);
            if (fileRev != null && (fileStore = fileRev.getStorage(null)) != null && (filePath = fileStore.getFullPath()) != null) {
                aTargetFileVer.setRepositoryPath(filePath.toPortableString());
            }
            if ((fileRelPath = aScmArt.getProjectRelativePath()) == null) {
                R4EUIPlugin.Ftracer.traceDebug("Invalid relative file path in scmArtifact with path: " + aScmArt.getPath());
            }
            IProject project = ResourceUtils.getProject((String)aScmArt.getProjectName());
            IResource resource = ResourceUtils.findResource((IProject)project, (String)fileRelPath);
            aTargetFileVer.setPlatformURI(ResourceUtils.toPlatformURIStr((IResource)resource));
            aTargetFileVer.setResource(resource);
            String projPlatformURI = ResourceUtils.toPlatformURIStr((IResource)project);
            if (projPlatformURI == null) {
                R4EUIPlugin.Ftracer.traceDebug("Unable to resolve the project: " + aScmArt.getProjectName() + " platform's URI, in scmArtifact with path: " + aScmArt.getPath());
            }
        }
    }

    public static void updateFileVersion(R4EFileVersion aTargetFileVer, IFile aSrcFile) {
        if (aTargetFileVer != null && aSrcFile != null) {
            aTargetFileVer.setName(aSrcFile.getName());
            aTargetFileVer.setRepositoryPath("");
            aTargetFileVer.setResource((IResource)aSrcFile);
            aTargetFileVer.setPlatformURI(ResourceUtils.toPlatformURIStr((IResource)aSrcFile));
        }
    }

    public static boolean useWorkspaceResource(R4EFileVersion aVersion) {
        try {
            IRFSRegistry localRepository;
            if (R4EUIModelController.getActiveReview() != null && (localRepository = RFSRegistryFactory.getRegistry((R4EReview)R4EUIModelController.getActiveReview().getReview())) != null && aVersion != null && aVersion.getResource() != null) {
                String workspaceFileId = localRepository.blobIdFor(((IFile)aVersion.getResource()).getContents());
                String repoFileId = aVersion.getLocalVersionID();
                if (workspaceFileId != null && workspaceFileId.equals(repoFileId)) {
                    return true;
                }
            }
        }
        catch (ReviewsFileStorageException e) {
            R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        catch (CoreException e) {
            R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        return false;
    }

    public static R4ECompareEditorInput createCompareEditorInput(R4EFileVersion aBaseFileVersion, R4EFileVersion aTargetFileVersion) {
        CompareConfiguration config = new CompareConfiguration();
        config.setRightEditable(false);
        config.setProperty("IGNORE_WHITESPACE", (Object)true);
        ITypedElement ancestor = null;
        IAdaptable target = null;
        if (aTargetFileVersion != null) {
            if (CommandUtils.useWorkspaceResource(aTargetFileVersion)) {
                target = new R4EFileTypedElement(aTargetFileVersion);
                config.setLeftEditable(true);
            } else {
                target = new R4EFileRevisionTypedElement(aTargetFileVersion);
                config.setLeftEditable(false);
            }
        }
        IAdaptable base = null;
        if (aBaseFileVersion != null) {
            if (CommandUtils.useWorkspaceResource(aBaseFileVersion)) {
                base = new R4EFileTypedElement(aBaseFileVersion);
                config.setRightEditable(true);
            } else {
                base = new R4EFileRevisionTypedElement(aBaseFileVersion);
                config.setRightEditable(false);
            }
        }
        return new R4ECompareEditorInput(config, ancestor, (ITypedElement)target, (ITypedElement)base);
    }

    public static R4EAnomalyTextPosition getAnomalyPosition(R4EAnomaly aAnomaly) {
        R4EContent content;
        EList location;
        if (aAnomaly != null && (location = aAnomaly.getLocation()) != null && location.size() > 0 && (content = (R4EContent)location.get(0)) != null) {
            R4EAnomalyTextPosition position = (R4EAnomalyTextPosition)content.getLocation();
            return position;
        }
        return null;
    }

    public static R4EFileVersion getAnomalyParentFile(R4EAnomaly aAnomaly) {
        R4EAnomalyTextPosition position;
        R4EContent content;
        EList location;
        if (aAnomaly != null && (location = aAnomaly.getLocation()) != null && location.size() > 0 && (content = (R4EContent)location.get(0)) != null && (position = (R4EAnomalyTextPosition)content.getLocation()) != null) {
            return position.getFile();
        }
        return null;
    }

    public static void copyAnomalyData(R4EAnomaly aTargetAnomaly, R4EAnomaly aSourceAnomaly) throws ResourceHandlingException, OutOfSyncException {
        if (aTargetAnomaly != null && aSourceAnomaly != null) {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)aTargetAnomaly, R4EUIModelController.getReviewer());
            aTargetAnomaly.setCreatedOn(aSourceAnomaly.getCreatedOn());
            aTargetAnomaly.setDecidedByID(aSourceAnomaly.getDecidedByID());
            aTargetAnomaly.setFixedByID(aSourceAnomaly.getFixedByID());
            aTargetAnomaly.setFollowUpByID(aSourceAnomaly.getFollowUpByID());
            aTargetAnomaly.setState(aSourceAnomaly.getState());
            aTargetAnomaly.setFixedInVersion(aSourceAnomaly.getFixedInVersion());
            aTargetAnomaly.setNotAcceptedReason(aSourceAnomaly.getNotAcceptedReason());
            if (aTargetAnomaly.getTitle() == null || "".equals(aTargetAnomaly.getTitle())) {
                aTargetAnomaly.setTitle(aSourceAnomaly.getTitle());
            }
            if (aTargetAnomaly.getDescription() == null || "".equals(aTargetAnomaly.getDescription())) {
                aTargetAnomaly.setDescription(aSourceAnomaly.getDescription());
            }
            if (aTargetAnomaly.getRank() == null) {
                aTargetAnomaly.setRank(aSourceAnomaly.getRank());
            }
            if (aTargetAnomaly.getRuleID() == null && aSourceAnomaly.getRuleID() != null) {
                aTargetAnomaly.setRuleID(aSourceAnomaly.getRuleID());
            }
            if (aSourceAnomaly.getType() != null) {
                R4ECommentType oldCommentType = (R4ECommentType)aSourceAnomaly.getType();
                R4ECommentType commentType = (R4ECommentType)aTargetAnomaly.getType();
                if (oldCommentType != null && commentType == null) {
                    commentType = RModelFactory.eINSTANCE.createR4ECommentType();
                    if (commentType != null) {
                        commentType.setType(oldCommentType.getType());
                    }
                    aTargetAnomaly.setType((CommentType)commentType);
                }
            }
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
    }

    public static void showPostponedElements(R4EUIReviewBasic aReview) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        R4EUIPostponedContainer container;
        if (aReview != null && (container = aReview.getPostponedContainer()) != null) {
            boolean containerEnabled = false;
            IR4EUIModelElement[] iR4EUIModelElementArray = container.getChildren();
            int n = iR4EUIModelElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IR4EUIModelElement element = iR4EUIModelElementArray[n2];
                if (element != null) {
                    int n3;
                    if (element instanceof R4EUIPostponedFile) {
                        R4EUIPostponedFile postFile = (R4EUIPostponedFile)element;
                        IR4EUIModelElement[] iR4EUIModelElementArray2 = postFile.getChildren();
                        int n4 = iR4EUIModelElementArray2.length;
                        n3 = 0;
                        while (n3 < n4) {
                            IR4EUIModelElement anomaly = iR4EUIModelElementArray2[n3];
                            if (anomaly != null && !anomaly.isEnabled()) {
                                element.removeChildren(anomaly, false);
                            }
                            ++n3;
                        }
                        if (!element.hasChildren()) {
                            element.close();
                        } else {
                            containerEnabled = true;
                        }
                    } else if (element instanceof R4EUIPostponedAnomalyContainer) {
                        IR4EUIModelElement[] iR4EUIModelElementArray3 = element.getChildren();
                        n3 = iR4EUIModelElementArray3.length;
                        int n5 = 0;
                        while (n5 < n3) {
                            IR4EUIModelElement anomaly = iR4EUIModelElementArray3[n5];
                            if (anomaly != null && !anomaly.isEnabled()) {
                                element.removeChildren(anomaly, false);
                            }
                            ++n5;
                        }
                        if (!element.hasChildren()) {
                            element.close();
                            container.removeChildren(element, false);
                        } else {
                            containerEnabled = true;
                        }
                    }
                }
                ++n2;
            }
            if (!containerEnabled) {
                container.close();
            }
        }
    }

    public static R4EAnomaly getOriginalAnomaly(R4EReview aOriginalReview, R4EAnomaly aCurrentAnomaly) {
        R4EUser origUser;
        String[] origIdTokens;
        if (aOriginalReview != null && aCurrentAnomaly != null && (origIdTokens = ((String)aCurrentAnomaly.getInfoAtt().get((Object)"originalAnomalyId")).split("/")) != null && (origUser = (R4EUser)aOriginalReview.getUsersMap().get((Object)origIdTokens[0])) != null) {
            for (R4EComment anomaly : origUser.getAddedComments()) {
                Integer id;
                if (!(anomaly instanceof R4EAnomaly) || (id = Integer.valueOf(origIdTokens[1])) == null || id.intValue() != anomaly.getId().getSequenceID()) continue;
                return (R4EAnomaly)anomaly;
            }
        }
        return null;
    }

    public static String buildOriginalAnomalyID(R4EAnomaly aOrigAnomaly) {
        return String.valueOf(aOrigAnomaly.getId().getUserID()) + "/" + aOrigAnomaly.getId().getSequenceID();
    }

    public static String buildOriginalCommentID(R4EComment aOrigComment) {
        return String.valueOf(aOrigComment.getId().getUserID()) + aOrigComment.getId().getSequenceID();
    }

    public static R4EParticipant getParticipantForReview(R4EReview aReview, String aParticipantId) throws ResourceHandlingException {
        if (aReview == null) {
            return null;
        }
        R4EParticipant participant = (R4EParticipant)aReview.getUsersMap().get((Object)aParticipantId);
        if (participant == null) {
            ArrayList<R4EUserRole> role = new ArrayList<R4EUserRole>(1);
            role.add(R4EUserRole.R4E_ROLE_REVIEWER);
            participant = R4EUIModelController.FModelExt.createR4EParticipant(aReview, aParticipantId, role);
        }
        return participant;
    }

    public static boolean isEmailValid(String aEmailAddress) {
        Matcher matcher;
        if (aEmailAddress == null || aEmailAddress.equals("")) {
            return true;
        }
        boolean result = false;
        Pattern pattern = Pattern.compile("^([\\w]((\\.(?!\\.))|[-!#\\$%'\\*\\+/=\\?\\^`\\{\\}\\|~\\w])*)(?<=[\\w])@(([\\w][-\\w]*[\\w]\\.)+[a-zA-Z]{2,6})$", 2);
        if (pattern != null && (matcher = pattern.matcher(aEmailAddress)) != null) {
            result = matcher.matches();
        }
        if (!result) {
            final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Invalid format for Participant Email", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, String.valueOf(aEmailAddress) + " is invalid", null), 4);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (dialog != null) {
                        dialog.open();
                    }
                }
            });
        }
        return result;
    }
}

